/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.maven;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.github.davidmoten.aws.maven.AbstractDeployAwsMojo;
import com.github.davidmoten.aws.maven.S3FileDeployer;
import java.io.File;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="deployFileS3")
public final class S3FileDeployerMojo
extends AbstractDeployAwsMojo<AmazonS3ClientBuilder, AmazonS3> {
    @Parameter(property="bucketName", required=true)
    private String bucketName;
    @Parameter(property="file", required=true)
    private File file;
    @Parameter(property="objectName")
    private String objectName;
    @Parameter(property="create", defaultValue="false")
    private boolean create;
    @Parameter(property="awsKmsKeyId")
    private String awsKmsKeyId;

    public S3FileDeployerMojo() {
        super(AmazonS3ClientBuilder.standard());
    }

    @Override
    protected void execute(AmazonS3 s3Client) {
        S3FileDeployer deployer = new S3FileDeployer(this.getLog(), s3Client);
        if (this.objectName == null) {
            this.objectName = this.file.getName();
        }
        deployer.deploy(this.file, this.bucketName, this.objectName, this.create, this.awsKmsKeyId);
    }
}

