/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.maven;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;

@Mojo(name="decrypt")
public final class DecryptMojo
extends AbstractMojo {
    @Parameter(name="serverId", required=true)
    private String serverId;
    @Parameter(name="outputFile", required=true)
    private File outputFile;
    @Component
    private Settings settings;
    @Component
    private SettingsDecrypter decrypter;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Server server = null;
        for (Server s : this.settings.getServers()) {
            if (!s.getId().equals(this.serverId)) continue;
            server = s;
        }
        if (server == null) {
            throw new MojoExecutionException("serverId not found in settings: " + this.serverId);
        }
        DefaultSettingsDecryptionRequest request = new DefaultSettingsDecryptionRequest(server);
        SettingsDecryptionResult result = this.decrypter.decrypt((SettingsDecryptionRequest)request);
        String password = result.getServer().getPassword();
        try {
            this.outputFile.getParentFile().mkdirs();
            Files.write(this.outputFile.toPath(), password.getBytes(Charset.forName("UTF-8")), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }
}

