/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.geo;

import com.github.davidmoten.geo.CoverageLongs;
import com.github.davidmoten.geo.GeoHash;
import java.util.Set;
import java.util.TreeSet;

public class Coverage {
    private final Set<String> hashes;
    private final double ratio;

    public Coverage(Set<String> hashes, double ratio) {
        this.hashes = hashes;
        this.ratio = ratio;
    }

    Coverage(CoverageLongs coverage) {
        this.ratio = coverage.getRatio();
        this.hashes = new TreeSet<String>();
        long[] arr$ = coverage.getHashes();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Long l = arr$[i$];
            this.hashes.add(GeoHash.fromLongToString(l));
        }
    }

    public Set<String> getHashes() {
        return this.hashes;
    }

    public double getRatio() {
        return this.ratio;
    }

    public int getHashLength() {
        if (this.hashes.size() == 0) {
            return 0;
        }
        return this.hashes.iterator().next().length();
    }

    public String toString() {
        return "Coverage [hashes=" + this.hashes + ", ratio=" + this.ratio + "]";
    }
}

