/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.geo;

import com.github.davidmoten.geo.Coverage;
import com.github.davidmoten.geo.CoverageLongs;
import com.github.davidmoten.geo.Direction;
import com.github.davidmoten.geo.LatLong;
import com.github.davidmoten.geo.Parity;
import com.github.davidmoten.geo.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GeoHash {
    private static final double PRECISION = 1.0E-12;
    public static final int MAX_HASH_LENGTH = 12;
    public static final int DEFAULT_MAX_HASHES = 12;
    private static final int[] BITS = new int[]{16, 8, 4, 2, 1};
    private static final String BASE32 = "0123456789bcdefghjkmnpqrstuvwxyz";
    private static final Map<Direction, Map<Parity, String>> NEIGHBOURS = GeoHash.createNeighbours();
    private static final Map<Direction, Map<Parity, String>> BORDERS = GeoHash.createBorders();

    private GeoHash() {
    }

    private static Map<Direction, Map<Parity, String>> createBorders() {
        Map<Direction, Map<Parity, String>> m = GeoHash.createDirectionParityMap();
        m.get((Object)Direction.RIGHT).put(Parity.EVEN, "bcfguvyz");
        m.get((Object)Direction.LEFT).put(Parity.EVEN, "0145hjnp");
        m.get((Object)Direction.TOP).put(Parity.EVEN, "prxz");
        m.get((Object)Direction.BOTTOM).put(Parity.EVEN, "028b");
        GeoHash.addOddParityEntries(m);
        return m;
    }

    private static Map<Direction, Map<Parity, String>> createNeighbours() {
        Map<Direction, Map<Parity, String>> m = GeoHash.createDirectionParityMap();
        m.get((Object)Direction.RIGHT).put(Parity.EVEN, "bc01fg45238967deuvhjyznpkmstqrwx");
        m.get((Object)Direction.LEFT).put(Parity.EVEN, "238967debc01fg45kmstqrwxuvhjyznp");
        m.get((Object)Direction.TOP).put(Parity.EVEN, "p0r21436x8zb9dcf5h7kjnmqesgutwvy");
        m.get((Object)Direction.BOTTOM).put(Parity.EVEN, "14365h7k9dcfesgujnmqp0r2twvyx8zb");
        GeoHash.addOddParityEntries(m);
        return m;
    }

    private static Map<Direction, Map<Parity, String>> createDirectionParityMap() {
        Map<Direction, Map<Parity, String>> m = GeoHash.newHashMap();
        m.put(Direction.BOTTOM, GeoHash.newHashMap());
        m.put(Direction.TOP, GeoHash.newHashMap());
        m.put(Direction.LEFT, GeoHash.newHashMap());
        m.put(Direction.RIGHT, GeoHash.newHashMap());
        return m;
    }

    private static <T, D> Map<T, D> newHashMap() {
        return new HashMap();
    }

    private static void addOddParityEntries(Map<Direction, Map<Parity, String>> m) {
        m.get((Object)Direction.BOTTOM).put(Parity.ODD, m.get((Object)Direction.LEFT).get((Object)Parity.EVEN));
        m.get((Object)Direction.TOP).put(Parity.ODD, m.get((Object)Direction.RIGHT).get((Object)Parity.EVEN));
        m.get((Object)Direction.LEFT).put(Parity.ODD, m.get((Object)Direction.BOTTOM).get((Object)Parity.EVEN));
        m.get((Object)Direction.RIGHT).put(Parity.ODD, m.get((Object)Direction.TOP).get((Object)Parity.EVEN));
    }

    public static String adjacentHash(String hash, Direction direction) {
        GeoHash.checkHash(hash);
        Preconditions.checkArgument(hash.length() > 0, "adjacent has no meaning for a zero length hash that covers the whole world");
        String adjacentHashAtBorder = GeoHash.adjacentHashAtBorder(hash, direction);
        if (adjacentHashAtBorder != null) {
            return adjacentHashAtBorder;
        }
        String source = hash.toLowerCase();
        char lastChar = source.charAt(source.length() - 1);
        Parity parity = source.length() % 2 == 0 ? Parity.EVEN : Parity.ODD;
        String base = source.substring(0, source.length() - 1);
        if (BORDERS.get((Object)direction).get((Object)parity).indexOf(lastChar) != -1) {
            base = GeoHash.adjacentHash(base, direction);
        }
        return base + BASE32.charAt(NEIGHBOURS.get((Object)direction).get((Object)parity).indexOf(lastChar));
    }

    private static String adjacentHashAtBorder(String hash, Direction direction) {
        LatLong centre = GeoHash.decodeHash(hash);
        if (Direction.RIGHT.equals((Object)direction)) {
            if (Math.abs(centre.getLon() + GeoHash.widthDegrees(hash.length()) / 2.0 - 180.0) < 1.0E-12) {
                return GeoHash.encodeHash(centre.getLat(), -180.0, hash.length());
            }
        } else if (Direction.LEFT.equals((Object)direction)) {
            if (Math.abs(centre.getLon() - GeoHash.widthDegrees(hash.length()) / 2.0 + 180.0) < 1.0E-12) {
                return GeoHash.encodeHash(centre.getLat(), 180.0, hash.length());
            }
        } else if (Direction.TOP.equals((Object)direction) ? Math.abs(centre.getLat() + GeoHash.widthDegrees(hash.length()) / 2.0 - 90.0) < 1.0E-12 : Math.abs(centre.getLat() - GeoHash.widthDegrees(hash.length()) / 2.0 + 90.0) < 1.0E-12) {
            return GeoHash.encodeHash(centre.getLat(), centre.getLon() + 180.0, hash.length());
        }
        return null;
    }

    private static void checkHash(String hash) {
        Preconditions.checkArgument(hash != null, "hash must be non-null");
    }

    public static String right(String hash) {
        return GeoHash.adjacentHash(hash, Direction.RIGHT);
    }

    public static String left(String hash) {
        return GeoHash.adjacentHash(hash, Direction.LEFT);
    }

    public static String top(String hash) {
        return GeoHash.adjacentHash(hash, Direction.TOP);
    }

    public static String bottom(String hash) {
        return GeoHash.adjacentHash(hash, Direction.BOTTOM);
    }

    public static String adjacentHash(String hash, Direction direction, int steps) {
        if (steps < 0) {
            return GeoHash.adjacentHash(hash, direction.opposite(), Math.abs(steps));
        }
        String h = hash;
        for (int i = 0; i < steps; ++i) {
            h = GeoHash.adjacentHash(h, direction);
        }
        return h;
    }

    public static List<String> neighbours(String hash) {
        ArrayList<String> list = new ArrayList<String>();
        String left = GeoHash.adjacentHash(hash, Direction.LEFT);
        String right = GeoHash.adjacentHash(hash, Direction.RIGHT);
        list.add(left);
        list.add(right);
        list.add(GeoHash.adjacentHash(hash, Direction.TOP));
        list.add(GeoHash.adjacentHash(hash, Direction.BOTTOM));
        list.add(GeoHash.adjacentHash(left, Direction.TOP));
        list.add(GeoHash.adjacentHash(left, Direction.BOTTOM));
        list.add(GeoHash.adjacentHash(right, Direction.TOP));
        list.add(GeoHash.adjacentHash(right, Direction.BOTTOM));
        return list;
    }

    public static String encodeHash(double latitude, double longitude) {
        return GeoHash.encodeHash(latitude, longitude, 12);
    }

    public static String encodeHash(LatLong p, int length) {
        return GeoHash.encodeHash(p.getLat(), p.getLon(), length);
    }

    public static String encodeHash(LatLong p) {
        return GeoHash.encodeHash(p.getLat(), p.getLon(), 12);
    }

    public static String encodeHash(double latitude, double longitude, int length) {
        Preconditions.checkArgument(length > 0 && length <= 12, "length must be between 1 and 12");
        Preconditions.checkArgument(latitude >= -90.0 && latitude <= 90.0, "latitude must be between -90 and 90 inclusive");
        longitude = GeoHash.to180(longitude);
        return GeoHash.fromLongToString(GeoHash.encodeHashToLong(latitude, longitude, length));
    }

    static String fromLongToString(long hash) {
        int length = (int)(hash & 0xFL);
        if (length > 12 || length < 1) {
            throw new IllegalArgumentException("invalid long geohash " + hash);
        }
        char[] geohash = new char[length];
        for (int pos = 0; pos < length; ++pos) {
            geohash[pos] = BASE32.charAt((int)(hash >>> 59));
            hash <<= 5;
        }
        return new String(geohash);
    }

    static long encodeHashToLong(double latitude, double longitude, int length) {
        boolean isEven = true;
        double minLat = -90.0;
        double maxLat = 90.0;
        double minLon = -180.0;
        double maxLon = 180.0;
        long g = 0L;
        long target = Long.MIN_VALUE >>> 5 * length;
        for (long bit = Long.MIN_VALUE; bit != target; bit >>>= 1) {
            double mid;
            if (isEven) {
                mid = (minLon + maxLon) / 2.0;
                if (longitude >= mid) {
                    g |= bit;
                    minLon = mid;
                } else {
                    maxLon = mid;
                }
            } else {
                mid = (minLat + maxLat) / 2.0;
                if (latitude >= mid) {
                    g |= bit;
                    minLat = mid;
                } else {
                    maxLat = mid;
                }
            }
            isEven = !isEven;
        }
        return g |= (long)length;
    }

    public static LatLong decodeHash(String geohash) {
        Preconditions.checkNotNull(geohash, "geohash cannot be null");
        boolean isEven = true;
        double[] lat = new double[2];
        double[] lon = new double[2];
        lat[0] = -90.0;
        lat[1] = 90.0;
        lon[0] = -180.0;
        lon[1] = 180.0;
        for (int i = 0; i < geohash.length(); ++i) {
            char c = geohash.charAt(i);
            int cd = BASE32.indexOf(c);
            for (int j = 0; j < 5; ++j) {
                int mask = BITS[j];
                if (isEven) {
                    GeoHash.refineInterval(lon, cd, mask);
                } else {
                    GeoHash.refineInterval(lat, cd, mask);
                }
                isEven = !isEven;
            }
        }
        double resultLat = (lat[0] + lat[1]) / 2.0;
        double resultLon = (lon[0] + lon[1]) / 2.0;
        return new LatLong(resultLat, resultLon);
    }

    private static void refineInterval(double[] interval, int cd, int mask) {
        if ((cd & mask) != 0) {
            interval[0] = (interval[0] + interval[1]) / 2.0;
        } else {
            interval[1] = (interval[0] + interval[1]) / 2.0;
        }
    }

    public static int hashLengthToCoverBoundingBox(double topLeftLat, double topLeftLon, double bottomRightLat, double bottomRightLon) {
        boolean isEven = true;
        double minLat = -90.0;
        double maxLat = 90.0;
        double minLon = -180.0;
        double maxLon = 180.0;
        for (int bits = 0; bits < 60; ++bits) {
            double mid;
            if (isEven) {
                mid = (minLon + maxLon) / 2.0;
                if (topLeftLon >= mid) {
                    if (bottomRightLon < mid) {
                        return bits / 5;
                    }
                    minLon = mid;
                } else {
                    if (bottomRightLon >= mid) {
                        return bits / 5;
                    }
                    maxLon = mid;
                }
            } else {
                mid = (minLat + maxLat) / 2.0;
                if (topLeftLat >= mid) {
                    if (bottomRightLat < mid) {
                        return bits / 5;
                    }
                    minLat = mid;
                } else {
                    if (bottomRightLat >= mid) {
                        return bits / 5;
                    }
                    maxLat = mid;
                }
            }
            isEven = !isEven;
        }
        return 12;
    }

    public static boolean hashContains(String hash, double lat, double lon) {
        LatLong centre = GeoHash.decodeHash(hash);
        return Math.abs(centre.getLat() - lat) <= GeoHash.heightDegrees(hash.length()) / 2.0 && Math.abs(GeoHash.to180(centre.getLon() - lon)) <= GeoHash.widthDegrees(hash.length()) / 2.0;
    }

    public static Coverage coverBoundingBox(double topLeftLat, double topLeftLon, double bottomRightLat, double bottomRightLon) {
        return GeoHash.coverBoundingBoxMaxHashes(topLeftLat, topLeftLon, bottomRightLat, bottomRightLon, 12);
    }

    public static Coverage coverBoundingBoxMaxHashes(double topLeftLat, double topLeftLon, double bottomRightLat, double bottomRightLon, int maxHashes) {
        CoverageLongs coverage = null;
        int startLength = GeoHash.hashLengthToCoverBoundingBox(topLeftLat, topLeftLon, bottomRightLat, bottomRightLon);
        if (startLength == 0) {
            startLength = 1;
        }
        for (int length = startLength; length <= 12; ++length) {
            CoverageLongs c = GeoHash.coverBoundingBoxLongs(topLeftLat, topLeftLon, bottomRightLat, bottomRightLon, length);
            if (c.getCount() > maxHashes) {
                return coverage == null ? null : new Coverage(coverage);
            }
            coverage = c;
        }
        return new Coverage(coverage);
    }

    public static Coverage coverBoundingBox(double topLeftLat, double topLeftLon, double bottomRightLat, double bottomRightLon, int length) {
        return new Coverage(GeoHash.coverBoundingBoxLongs(topLeftLat, topLeftLon, bottomRightLat, bottomRightLon, length));
    }

    static CoverageLongs coverBoundingBoxLongs(double topLeftLat, double topLeftLon, double bottomRightLat, double bottomRightLon, int length) {
        double lat;
        Preconditions.checkArgument(topLeftLat >= bottomRightLat, "topLeftLat must be >= bottomRighLat");
        Preconditions.checkArgument(topLeftLon <= bottomRightLon, "topLeftLon must be <= bottomRighLon");
        Preconditions.checkArgument(length > 0, "length must be greater than zero");
        double actualWidthDegreesPerHash = GeoHash.widthDegrees(length);
        double actualHeightDegreesPerHash = GeoHash.heightDegrees(length);
        LongSet hashes = new LongSet();
        double diff = GeoHash.longitudeDiff(bottomRightLon, topLeftLon);
        double maxLon = topLeftLon + diff;
        for (lat = bottomRightLat; lat <= topLeftLat; lat += actualHeightDegreesPerHash) {
            for (double lon = topLeftLon; lon <= maxLon; lon += actualWidthDegreesPerHash) {
                hashes.add(GeoHash.encodeHashToLong(lat, lon, length));
            }
        }
        for (lat = bottomRightLat; lat <= topLeftLat; lat += actualHeightDegreesPerHash) {
            hashes.add(GeoHash.encodeHashToLong(lat, maxLon, length));
        }
        for (double lon = topLeftLon; lon <= maxLon; lon += actualWidthDegreesPerHash) {
            hashes.add(GeoHash.encodeHashToLong(topLeftLat, lon, length));
        }
        hashes.add(GeoHash.encodeHashToLong(topLeftLat, maxLon, length));
        double areaDegrees = diff * (topLeftLat - bottomRightLat);
        double coverageAreaDegrees = (double)hashes.count * GeoHash.widthDegrees(length) * GeoHash.heightDegrees(length);
        double ratio = coverageAreaDegrees / areaDegrees;
        return new CoverageLongs(hashes.array, hashes.count, ratio);
    }

    public static double heightDegrees(int n) {
        if (n > 12) {
            return GeoHash.calculateHeightDegrees(n);
        }
        return HashHeights.values[n];
    }

    private static double calculateHeightDegrees(int n) {
        double a = n % 2 == 0 ? 0.0 : -0.5;
        double result = 180.0 / Math.pow(2.0, 2.5 * (double)n + a);
        return result;
    }

    public static double widthDegrees(int n) {
        if (n > 12) {
            return GeoHash.calculateWidthDegrees(n);
        }
        return HashWidths.values[n];
    }

    private static double calculateWidthDegrees(int n) {
        double a = n % 2 == 0 ? -1.0 : -0.5;
        double result = 180.0 / Math.pow(2.0, 2.5 * (double)n + a);
        return result;
    }

    public static String gridAsString(String hash, int size, Set<String> highlightThese) {
        return GeoHash.gridAsString(hash, -size, -size, size, size, highlightThese);
    }

    public static String gridAsString(String hash, int fromRight, int fromBottom, int toRight, int toBottom) {
        return GeoHash.gridAsString(hash, fromRight, fromBottom, toRight, toBottom, Collections.<String>emptySet());
    }

    public static String gridAsString(String hash, int fromRight, int fromBottom, int toRight, int toBottom, Set<String> highlightThese) {
        StringBuilder s = new StringBuilder();
        for (int bottom = fromBottom; bottom <= toBottom; ++bottom) {
            for (int right = fromRight; right <= toRight; ++right) {
                String h = GeoHash.adjacentHash(hash, Direction.RIGHT, right);
                if (highlightThese.contains(h = GeoHash.adjacentHash(h, Direction.BOTTOM, bottom))) {
                    h = h.toUpperCase();
                }
                s.append(h).append(" ");
            }
            s.append("\n");
        }
        return s.toString();
    }

    private static double to180(double d) {
        if (d < 0.0) {
            return -GeoHash.to180(Math.abs(d));
        }
        if (d > 180.0) {
            long n = Math.round(Math.floor((d + 180.0) / 360.0));
            return d - (double)(n * 360L);
        }
        return d;
    }

    private static double longitudeDiff(double a, double b) {
        a = GeoHash.to180(a);
        b = GeoHash.to180(b);
        return Math.abs(GeoHash.to180(a - b));
    }

    private static final class HashWidths {
        static final double[] values = HashWidths.createValues();

        private HashWidths() {
        }

        private static double[] createValues() {
            double[] d = new double[13];
            for (int i = 0; i <= 12; ++i) {
                d[i] = GeoHash.calculateWidthDegrees(i);
            }
            return d;
        }
    }

    private static final class HashHeights {
        static final double[] values = HashHeights.createValues();

        private HashHeights() {
        }

        private static double[] createValues() {
            double[] d = new double[13];
            for (int i = 0; i <= 12; ++i) {
                d[i] = GeoHash.calculateHeightDegrees(i);
            }
            return d;
        }
    }

    private static class LongSet {
        int count = 0;
        private int cap = 16;
        long[] array = new long[this.cap];

        private LongSet() {
        }

        void add(long l) {
            for (int i = 0; i < this.count; ++i) {
                if (this.array[i] != l) continue;
                return;
            }
            if (this.count == this.cap) {
                long[] newArray = new long[this.cap *= 2];
                System.arraycopy(this.array, 0, newArray, 0, this.count);
                this.array = newArray;
            }
            this.array[this.count++] = l;
        }
    }
}

