/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.io.extras.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Queue;
import org.davidmoten.io.extras.internal.Util;

public final class QueuedOutputStream
extends OutputStream {
    private final Queue<ByteBuffer> queue;
    private final int[] count;

    QueuedOutputStream(Queue<ByteBuffer> queue, int[] count) {
        this.queue = queue;
        this.count = count;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] bytes = new byte[]{(byte)b};
        this.add(ByteBuffer.wrap(bytes));
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.add(ByteBuffer.wrap(b));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.add(ByteBuffer.wrap(b, off, len));
    }

    private void add(ByteBuffer bb) {
        this.count[0] = this.count[0] + bb.remaining();
        this.queue.offer(Util.copy(bb));
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

