/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.io.extras.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import org.davidmoten.io.extras.IOFunction;
import org.davidmoten.io.extras.internal.QueuedOutputStream;

public final class TransformedInputStream
extends InputStream {
    private final InputStream is;
    private final Deque<ByteBuffer> queue;
    private final int bufferSize;
    private final OutputStream out;
    private final byte[] singleByte = new byte[1];
    private final byte[] buffer;
    private boolean done;
    private boolean closed;
    private int[] count = new int[1];

    public TransformedInputStream(InputStream is, IOFunction<? super OutputStream, ? extends OutputStream> transform, int bufferSize) throws IOException {
        this.is = is;
        this.queue = new ArrayDeque<ByteBuffer>();
        this.bufferSize = bufferSize;
        this.buffer = new byte[bufferSize];
        this.out = transform.apply(new QueuedOutputStream(this.queue, this.count));
    }

    @Override
    public int read() throws IOException {
        int n = this.readInternal(this.singleByte, 0, 1);
        if (n == -1) {
            return -1;
        }
        return this.singleByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.readInternal(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.readInternal(b, off, len);
    }

    private int readInternal(byte[] bytes, int offset, int length) throws IOException {
        int n;
        ByteBuffer bb;
        if (length == 0) {
            return 0;
        }
        if (this.closed) {
            throw new IOException("Stream closed");
        }
        while ((bb = this.queue.poll()) == null) {
            if (this.done) {
                return -1;
            }
            n = this.is.read(this.buffer);
            if (n == -1) {
                this.done = true;
                this.out.close();
                continue;
            }
            this.out.write(this.buffer, 0, n);
        }
        n = Math.min(bb.remaining(), length);
        if (bytes != null) {
            bb.get(bytes, offset, n);
        } else {
            bb.position(bb.position() + n);
        }
        this.count[0] = this.count[0] - n;
        if (bb.remaining() > 0) {
            this.queue.offerLast(bb);
        }
        return n;
    }

    @Override
    public long skip(long n) throws IOException {
        long result = 0L;
        while (true) {
            if (n == 0L) {
                return result;
            }
            int m = Math.min((int)Math.min(Integer.MAX_VALUE, n), this.bufferSize);
            int v = this.readInternal(null, 0, m);
            if (v == -1) break;
            result += (long)v;
            n -= (long)v;
        }
        if (result == 0L) {
            return -1L;
        }
        return result;
    }

    @Override
    public int available() throws IOException {
        return this.count[0];
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

