/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.jaxws;

import com.github.davidmoten.jaxws.WsImportMojo;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ResolutionListener;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;

class Util {
    private static final String PLUGIN_DESCRIPTOR = "pluginDescriptor";

    Util() {
    }

    static File createOutputDirectoryIfSpecifiedOrDefault(Log log, String param, List<String> arguments) {
        for (int i = 0; i < arguments.size(); ++i) {
            if (!Util.isOptionParamSpecifiedAndNotEmpty(arguments, i, param)) continue;
            File outputDir = new File(arguments.get(i + 1));
            if (!outputDir.exists()) {
                log.info((CharSequence)("destination directory (" + param + " option) specified and does not exist, creating: " + outputDir));
                outputDir.mkdirs();
            }
            return outputDir;
        }
        log.warn((CharSequence)("destination directory (" + param + " option) NOT specified. Generated source will be placed in project root if -keep argument is present."));
        return new File(".");
    }

    private static boolean isOptionParamSpecifiedAndNotEmpty(List<String> arguments, int index, String param) {
        String argValue = ((String)StringUtils.defaultIfBlank((CharSequence)arguments.get(index), (CharSequence)"")).trim();
        return StringUtils.equals((CharSequence)argValue, (CharSequence)param) && index < arguments.size() - 1;
    }

    static ResolutionListener createLoggingResolutionListener(final Log log) {
        return new ResolutionListener(){
            int depth = 0;

            private void log(String message) {
                log.debug((CharSequence)(Util.spaces(this.depth) + message));
            }

            public void testArtifact(Artifact artifact) {
                this.log("testArtifact: " + artifact.getArtifactId());
            }

            public void startProcessChildren(Artifact artifact) {
                this.log("startProcessChildren: " + Util.string(artifact));
                ++this.depth;
            }

            public void endProcessChildren(Artifact artifact) {
                --this.depth;
                this.log("endProcessChildren: " + Util.string(artifact));
            }

            public void includeArtifact(Artifact artifact) {
                this.log("includeArtifact: " + Util.string(artifact));
            }

            public void omitForNearer(Artifact omitted, Artifact kept) {
                this.log("omitForNearer: omitted=" + Util.string(omitted) + ", kept=" + Util.string(kept));
            }

            public void updateScope(Artifact artifact, String scope) {
                this.log("updateScope: " + Util.string(artifact) + ", scope=" + scope);
            }

            public void manageArtifact(Artifact artifact, Artifact replacement) {
                this.log("manageArtifact: " + Util.string(artifact) + ", replacement=" + Util.string(replacement));
            }

            public void omitForCycle(Artifact artifact) {
                this.log("omitForCycle: " + Util.string(artifact));
            }

            public void updateScopeCurrentPom(Artifact artifact, String ignoredScope) {
                this.log("updateScopeCurrentPom: " + Util.string(artifact));
            }

            public void selectVersionFromRange(Artifact artifact) {
                this.log("selectVersionFromRange: " + Util.string(artifact));
            }

            public void restrictRange(Artifact artifact, Artifact replacement, VersionRange newRange) {
                this.log("restrictRange: " + Util.string(artifact) + ", replacement=" + Util.string(replacement) + ", versionRange=" + newRange);
            }
        };
    }

    private static String spaces(int n) {
        StringBuilder b = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            b.append("  ");
        }
        return b.toString();
    }

    private static String string(Artifact a) {
        return a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getVersion() + ":" + a.getScope() + ":" + a.getType();
    }

    static ArtifactResolutionResult resolve(Log log, Artifact artifact, RepositorySystem repositorySystem, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(artifact).setLocalRepository(localRepository).setRemoteRepositories(remoteRepositories).setResolveTransitively(true).addListener(Util.createLoggingResolutionListener(log));
        return repositorySystem.resolve(request);
    }

    static String readConfigurationValue(String key) {
        Properties p = new Properties();
        try {
            p.load(WsImportMojo.class.getResourceAsStream("/configuration.properties"));
            return p.getProperty(key);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static Stream<String> getPluginRuntimeDependencyEntries(AbstractMojo mojo, MavenProject project, Log log, RepositorySystem repositorySystem, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) {
        PluginDescriptor pluginDescriptor = (PluginDescriptor)mojo.getPluginContext().get(PLUGIN_DESCRIPTOR);
        Plugin plugin = (Plugin)project.getBuild().getPluginsAsMap().get(pluginDescriptor.getPluginLookupKey());
        List artifactResolutionResults = plugin.getDependencies().stream().map(arg_0 -> ((RepositorySystem)repositorySystem).createDependencyArtifact(arg_0)).map(a -> Util.resolve(log, a, repositorySystem, localRepository, remoteRepositories)).collect(Collectors.toList());
        Stream<Artifact> originalArtifacts = artifactResolutionResults.stream().map(ArtifactResolutionResult::getOriginatingArtifact);
        Stream<Artifact> childArtifacts = artifactResolutionResults.stream().flatMap(resolutionResult -> resolutionResult.getArtifactResolutionNodes().stream()).map(ResolutionNode::getArtifact);
        return Stream.concat(originalArtifacts, childArtifacts).map(Artifact::getFile).map(File::getAbsolutePath);
    }
}

