/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.jaxws;

import com.github.davidmoten.jaxws.HasClasspathScope;
import com.github.davidmoten.jaxws.JaxCommand;
import com.github.davidmoten.jaxws.SchemaGenMojo;
import com.github.davidmoten.jaxws.Util;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.sonatype.plexus.build.incremental.BuildContext;
import org.zeroturnaround.exec.InvalidExitValueException;
import org.zeroturnaround.exec.ProcessExecutor;

abstract class BaseMojo
extends AbstractMojo {
    @Parameter(name="arguments", required=true)
    private List<String> arguments;
    @Parameter(name="systemProperties")
    private Map<String, String> systemProperties;
    @Parameter(name="jvmArguments", required=false)
    private List<String> jvmArguments;
    @Parameter(name="addSources", defaultValue="true")
    private boolean addSources;
    @Parameter(name="addResources", defaultValue="true")
    private boolean addResources;
    @Component
    private MavenProject project;
    @Component
    private BuildContext buildContext;
    @Component
    private RepositorySystem repositorySystem;
    @Parameter(defaultValue="${localRepository}", readonly=true, required=true)
    private ArtifactRepository localRepository;
    @Parameter(defaultValue="${remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteRepositories;
    private final JaxCommand cmd;

    BaseMojo(JaxCommand cmd) {
        this.cmd = cmd;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        Log log = this.getLog();
        log.info((CharSequence)("Starting " + (Object)((Object)this.cmd) + " mojo"));
        List<File> outputDirectories = this.cmd.getDirectoryParameters().stream().map(param -> Util.createOutputDirectoryIfSpecifiedOrDefault(log, param, this.arguments)).collect(Collectors.toList());
        try {
            List<String> command = this.createCommand();
            new ProcessExecutor().command(command).directory(this.project.getBasedir()).exitValueNormal().redirectOutput((OutputStream)System.out).redirectError((OutputStream)System.out).execute();
            outputDirectories.forEach(arg_0 -> ((BuildContext)this.buildContext).refresh(arg_0));
            this.addSources(log);
            this.addResources(log);
        }
        catch (IOException | InterruptedException | TimeoutException | DependencyResolutionRequiredException | InvalidExitValueException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        log.info((CharSequence)((Object)((Object)this.cmd) + " mojo finished"));
    }

    private void addResources(Log log) {
        if (this.addResources) {
            this.cmd.getResourceParameter().flatMap(parameterName -> Util.getNextArgument(this.arguments, parameterName)).ifPresent(x -> {
                Resource resource = new Resource();
                resource.setDirectory(x);
                this.project.addResource(resource);
                log.info((CharSequence)("added resource folder: " + x));
            });
        }
    }

    private void addSources(Log log) {
        if (this.addSources) {
            this.cmd.getSourceParameter().flatMap(parameterName -> Util.getNextArgument(this.arguments, parameterName)).ifPresent(x -> {
                this.project.addCompileSourceRoot(x);
                log.info((CharSequence)("added source folder to compile: " + x));
            });
        }
    }

    private List<String> createCommand() throws DependencyResolutionRequiredException {
        Log log = this.getLog();
        String mainArtifactVersion = Util.readConfigurationValue("project.parent.version");
        String mainArtifactGroupId = Util.readConfigurationValue("project.parent.groupId");
        Artifact artifact = this.repositorySystem.createArtifact(mainArtifactGroupId, "jax-maven-plugin-core", mainArtifactVersion, "", "jar");
        log.info((CharSequence)("setting up classpath for jaxws-tools version " + mainArtifactVersion));
        ArtifactResolutionResult r = Util.resolve(log, artifact, this.repositorySystem, this.localRepository, this.remoteRepositories);
        Stream<String> artifactEntry = Stream.of(artifact.getFile().getAbsolutePath());
        Stream<String> dependencyEntries = r.getArtifactResolutionNodes().stream().map(x -> x.getArtifact().getFile().getAbsolutePath());
        Stream<String> pluginDependencyEntries = Util.getPluginRuntimeDependencyEntries(this, this.project, log, this.repositorySystem, this.localRepository, this.remoteRepositories);
        Stream<String> fullDependencyEntries = Stream.concat(dependencyEntries, pluginDependencyEntries);
        StringBuilder classpath = new StringBuilder();
        classpath.append(Stream.concat(artifactEntry, fullDependencyEntries).collect(Collectors.joining(File.pathSeparator)));
        URLClassLoader classLoader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        for (URL url : classLoader.getURLs()) {
            File file = new File(url.getFile());
            log.debug((CharSequence)("plugin classpath entry: " + file.getAbsolutePath()));
            if (!file.getAbsolutePath().contains("xjc-maven-plugin-core") && !file.getAbsolutePath().contains("jaxws-maven-plugin-core")) continue;
            if (classpath.length() > 0) {
                classpath.append(File.pathSeparator);
            }
            classpath.append(file.getAbsolutePath());
        }
        log.debug((CharSequence)("isolated classpath for call to " + (Object)((Object)this.cmd) + "=\n  " + classpath.toString().replace(File.pathSeparator, File.pathSeparator + "\n  ")));
        String javaExecutable = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        ArrayList command = Lists.newArrayList((Object[])new String[]{javaExecutable, "-classpath", classpath.toString()});
        if (this.jvmArguments != null) {
            command.addAll(this.jvmArguments);
        }
        if (this.systemProperties != null) {
            command.addAll(this.systemProperties.entrySet().stream().map(entry -> "-D" + (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.toList()));
        }
        command.add(this.cmd.mainClass().getName());
        if (this instanceof HasClasspathScope) {
            String classpathScope = ((HasClasspathScope)((Object)this)).classpathScope();
            if (!this.arguments.stream().filter(x -> "-cp".equals(x.trim()) || "-classpath".equals(x.trim())).findFirst().isPresent()) {
                Set directDependencies = this.project.getDependencyArtifacts();
                Set artifacts = directDependencies.stream().filter(a -> a.getScope().equals(classpathScope)).map(a -> Util.resolve(log, a, this.repositorySystem, this.localRepository, this.remoteRepositories).getArtifacts()).flatMap(list -> list.stream()).collect(Collectors.toSet());
                artifacts.stream().forEach(a -> log.info((CharSequence)("dep=" + a.getArtifactId())));
                List cp = artifacts.stream().map(a -> a.getFile().getAbsolutePath()).collect(Collectors.toList());
                if ("compile".equals(classpathScope)) {
                    cp.addAll(this.project.getCompileClasspathElements());
                } else if ("runtime".equals(classpathScope)) {
                    cp.addAll(this.project.getRuntimeClasspathElements());
                } else if ("test".equals(classpathScope)) {
                    cp.addAll(this.project.getTestClasspathElements());
                } else {
                    throw new IllegalArgumentException("classpathScope " + classpathScope + " not recognized");
                }
                command.add("-cp");
                command.add(cp.stream().collect(Collectors.joining(File.pathSeparator)));
            }
        }
        command.addAll(this.arguments);
        if (this instanceof SchemaGenMojo) {
            List<String> sources = ((SchemaGenMojo)this).sources();
            HashSet javaSourceFiles = new HashSet();
            JavaFileVisitor visitor = new JavaFileVisitor(javaSourceFiles);
            sources.stream().forEach(source -> {
                Path path = Paths.get(source, new String[0]);
                try {
                    Files.walkFileTree(path, visitor);
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Error visiting sources", e);
                }
            });
            command.addAll(javaSourceFiles);
        }
        log.info((CharSequence)("call arguments:\n  -----------------\n  " + command.stream().collect(Collectors.joining("\n  ")) + "\n  -----------------"));
        return command;
    }

    private class JavaFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Set<String> javaFiles;

        private JavaFileVisitor(Set<String> javaFiles) {
            this.javaFiles = javaFiles;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            if (file.toString().toLowerCase().endsWith(".java")) {
                this.javaFiles.add(file.toString());
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

