/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool;

import com.github.davidmoten.guavamini.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.davidmoten.kool.Maybe;
import org.davidmoten.kool.RetryWhenBuilderSingle;
import org.davidmoten.kool.SingleTester;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterable;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.Function;
import org.davidmoten.kool.internal.operators.single.Map;
import org.davidmoten.kool.internal.operators.single.SingleDoOnError;
import org.davidmoten.kool.internal.operators.single.SingleDoOnValue;
import org.davidmoten.kool.internal.operators.single.SingleError;
import org.davidmoten.kool.internal.operators.single.SingleFlatMap;
import org.davidmoten.kool.internal.operators.single.SingleFlatMapMaybe;
import org.davidmoten.kool.internal.operators.single.SingleFromCallable;
import org.davidmoten.kool.internal.operators.single.SingleIterator;
import org.davidmoten.kool.internal.operators.single.SingleOf;
import org.davidmoten.kool.internal.operators.single.SingleSwitchOnError;
import org.davidmoten.kool.internal.operators.single.SingleToStream;

public interface Single<T>
extends StreamIterable<T> {
    public T get();

    public static <T> Single<T> of(T t) {
        return new SingleOf<T>(t);
    }

    public static <T> Single<T> fromCallable(Callable<? extends T> callable) {
        return new SingleFromCallable<T>(callable);
    }

    public static <T> Single<T> error(Callable<? extends Throwable> callable) {
        return new SingleError(callable);
    }

    public static <T> Single<T> error(Throwable error) {
        return Single.error(() -> error);
    }

    public static Single<Integer> timer(long duration, TimeUnit unit) {
        return Single.timer(1, duration, unit);
    }

    public static <T> Single<T> timer(T t, long duration, TimeUnit unit) {
        Preconditions.checkNotNull(t);
        Preconditions.checkNotNull((Object)((Object)unit));
        Preconditions.checkArgument((duration >= 0L ? 1 : 0) != 0);
        return Single.fromCallable(() -> {
            unit.sleep(duration);
            return t;
        });
    }

    default public <R> Single<R> map(Function<? super T, ? extends R> mapper) {
        return new Map<T, R>(mapper, this);
    }

    default public <R> Stream<R> flatMap(Function<? super T, ? extends StreamIterable<? extends R>> mapper) {
        return new SingleFlatMap(this, mapper);
    }

    default public <R> Maybe<R> flatMapMaybe(Function<? super T, ? extends Maybe<? extends R>> mapper) {
        return new SingleFlatMapMaybe(this, mapper);
    }

    default public Single<T> doOnValue(Consumer<? super T> consumer) {
        return new SingleDoOnValue<T>(consumer, this);
    }

    default public Single<T> doOnError(Consumer<? super Throwable> consumer) {
        return new SingleDoOnError(consumer, this);
    }

    default public <R> Single<T> switchOnError(Function<? super Throwable, ? extends Single<? extends T>> function) {
        return new SingleSwitchOnError(this, function);
    }

    default public SingleTester<T> test() {
        return new SingleTester(this);
    }

    default public Stream<T> toStream() {
        return new SingleToStream(this);
    }

    @Override
    default public StreamIterator<T> iterator() {
        return new SingleIterator(this);
    }

    default public <R> R to(Function<? super Single<T>, R> mapper) {
        return mapper.applyUnchecked(this);
    }

    default public void forEach() {
        this.get();
    }

    default public void go() {
        this.get();
    }

    default public void start() {
        this.get();
    }

    default public Stream<T> repeat() {
        return this.toStream().repeat();
    }

    default public Single<T> retryWhen(Function<? super Throwable, ? extends Single<?>> function) {
        return this.toStream().retryWhen(function).single();
    }

    default public RetryWhenBuilderSingle<T> retryWhen() {
        return new RetryWhenBuilderSingle(this);
    }

    default public Single<T> println() {
        return this.doOnValue(System.out::println);
    }
}

