/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool;

public final class Statistics {
    final double sum;
    final long count;
    final double sumSquared;
    final double m2;
    final double m3;
    final double m4;
    final double min;
    final double max;

    Statistics() {
        this(0.0, 0L, 0.0, 0.0, 0.0, 0.0, Double.MAX_VALUE, Double.MIN_VALUE);
    }

    Statistics(double sum, long count, double sumSquared, double m2, double m3, double m4, double min, double max) {
        this.sum = sum;
        this.count = count;
        this.sumSquared = sumSquared;
        this.m2 = m2;
        this.m3 = m3;
        this.m4 = m4;
        this.min = min;
        this.max = max;
    }

    Statistics add(double x) {
        long n = this.count + 1L;
        double mean = this.count == 0L ? 0.0 : this.mean();
        double delta = x - mean;
        double delta_n = delta / (double)n;
        double delta_n2 = delta_n * delta_n;
        double term1 = delta * delta_n * (double)(n - 1L);
        double m4 = this.m4 + term1 * delta_n2 * (double)(n * n - 3L * n + 3L) + 6.0 * delta_n2 * this.m2 - 4.0 * delta_n * this.m3;
        double m3 = this.m3 + term1 * delta_n * (double)(n - 2L) - 3.0 * delta_n * this.m2;
        double m2 = this.m2 + term1;
        double min = Math.min(x, this.min);
        double max = Math.max(x, this.max);
        return new Statistics(this.sum + x, this.count + 1L, this.sumSquared + x * x, m2, m3, m4, min, max);
    }

    public long count() {
        return this.count;
    }

    public double standardDeviation() {
        return Math.sqrt(this.sumSquared / (double)this.count - this.mean() * this.mean());
    }

    public double mean() {
        return this.sum / (double)this.count;
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public double kurtosis() {
        return (double)this.count * this.m4 / (this.m2 * this.m2);
    }

    public double excessKurtosis() {
        return this.kurtosis() - 3.0;
    }

    public double skewness() {
        return Math.sqrt(this.count) * this.m3 / Math.sqrt(this.m2) / this.m2;
    }

    public double range() {
        return this.max - this.min;
    }

    public double variance() {
        double sd = this.standardDeviation();
        return sd * sd;
    }

    public String toString(String prefix, String delimiter) {
        StringBuilder b = new StringBuilder();
        b.append(prefix);
        b.append("count=");
        b.append(this.count);
        b.append(delimiter);
        b.append(prefix);
        b.append("mean=");
        b.append(this.mean());
        b.append(delimiter);
        b.append(prefix);
        b.append("standardDeviation=");
        b.append(this.standardDeviation());
        b.append(delimiter);
        b.append(prefix);
        b.append("variance=");
        b.append(this.variance());
        b.append(delimiter);
        b.append(prefix);
        b.append("kurtosis=");
        b.append(this.kurtosis());
        b.append(delimiter);
        b.append(prefix);
        b.append("skewness=");
        b.append(this.skewness());
        b.append(delimiter);
        b.append(prefix);
        b.append("min=");
        b.append(this.min());
        b.append(delimiter);
        b.append(prefix);
        b.append("max=");
        b.append(this.max());
        b.append(delimiter);
        b.append(prefix);
        b.append("range=");
        b.append(this.range());
        b.append(delimiter);
        return b.toString();
    }

    public String toString() {
        return "Statistics [" + this.toString(" ", ",") + "]";
    }
}

