/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.function.Predicate;

public final class Tester<T> {
    private final List<T> list = new ArrayList<T>();
    private Throwable error;

    public Tester(Stream<T> stream) {
        try {
            Iterator it = stream.iterator();
            try {
                while (it.hasNext()) {
                    this.list.add(it.nextNullChecked());
                }
            }
            finally {
                it.dispose();
            }
            this.error = null;
        }
        catch (Throwable e) {
            this.error = e;
        }
    }

    @SafeVarargs
    public final Tester<T> assertValues(T ... expected) {
        if (!Arrays.asList(expected).equals(this.list)) {
            throw new AssertionError((Object)("values not equal: expected=" + Arrays.toString(expected) + ", found=" + this.list));
        }
        return this;
    }

    public Tester<T> assertNoValues() {
        if (!this.list.isEmpty()) {
            throw new AssertionError((Object)("values not empty: " + this.list));
        }
        return this;
    }

    public Tester<T> assertNoValuesOnly() {
        this.assertNoError();
        this.assertNoValues();
        return this;
    }

    @SafeVarargs
    public final Tester<T> assertValuesOnly(T ... expected) {
        this.assertNoError();
        this.assertValues(expected);
        return this;
    }

    public Tester<T> assertNoError() {
        if (this.error != null) {
            throw new AssertionError((Object)this.error);
        }
        return this;
    }

    public Tester<T> assertError(Class<? extends Throwable> cls) {
        if (this.error == null) {
            throw new AssertionError((Object)"no error thrown");
        }
        if (!this.error.getClass().isAssignableFrom(cls)) {
            throw new AssertionError((Object)("error " + this.error.getClass() + " is not an instance of " + cls));
        }
        return this;
    }

    public Tester<T> assertError(Predicate<? super Throwable> predicate) {
        if (this.error == null) {
            throw new AssertionError((Object)"no error thrown");
        }
        if (!predicate.testChecked(this.error)) {
            this.error.printStackTrace();
            throw new AssertionError((Object)("error " + this.error.getClass() + " failed predicate"));
        }
        return this;
    }

    public Tester<T> assertErrorMessage(String message) {
        return this.assertError((? super Throwable e) -> Objects.equals(message, e.getMessage()));
    }
}

