/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.maybe;

import com.github.davidmoten.guavamini.Preconditions;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.davidmoten.kool.Maybe;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterable;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.Function;
import org.davidmoten.kool.internal.util.EmptyStream;

public final class MaybeFlatMap<T, R>
implements Stream<R> {
    private final Maybe<T> maybe;
    private final Function<? super T, ? extends StreamIterable<? extends R>> mapper;

    public MaybeFlatMap(Maybe<T> maybe, Function<? super T, ? extends StreamIterable<? extends R>> mapper) {
        this.maybe = maybe;
        this.mapper = mapper;
    }

    @Override
    public StreamIterator<R> iterator() {
        return new StreamIterator<R>(){
            StreamIterator<? extends R> it;
            boolean finished;

            @Override
            public boolean hasNext() {
                this.load();
                return !this.finished && (Boolean)Preconditions.checkNotNull((Object)this.it.hasNext()) != false;
            }

            @Override
            public R next() {
                this.load();
                if (this.finished) {
                    throw new NoSuchElementException();
                }
                return this.it.next();
            }

            @Override
            public void dispose() {
                if (this.it != null) {
                    this.it.dispose();
                    this.it = null;
                    this.finished = true;
                }
            }

            private void load() {
                if (!this.finished && this.it == null) {
                    Optional v = MaybeFlatMap.this.maybe.get();
                    this.it = v.isPresent() ? ((StreamIterable)MaybeFlatMap.this.mapper.applyUnchecked(v.get())).iterator() : EmptyStream.INSTANCE.iterator();
                }
            }
        };
    }
}

