/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import java.util.NoSuchElementException;
import java.util.concurrent.Callable;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.BiFunction;
import org.davidmoten.kool.function.BiPredicate;
import org.davidmoten.kool.function.Function;
import org.davidmoten.kool.internal.operators.stream.ReplayableStreamIterator;
import org.davidmoten.kool.internal.util.Exceptions;

public final class BufferWithFactoryPredicateAndStep<S, T>
implements Stream<S> {
    private final Callable<? extends S> factory;
    private final BiFunction<? super S, ? super T, ? extends S> accumulator;
    private final BiPredicate<? super S, ? super T> condition;
    private final boolean emitRemainder;
    private final boolean until;
    private final Stream<T> source;
    private final Function<? super S, Integer> step;
    private final int maxReplay;

    public BufferWithFactoryPredicateAndStep(Callable<? extends S> factory, BiFunction<? super S, ? super T, ? extends S> accumulator, BiPredicate<? super S, ? super T> condition, boolean emitRemainder, boolean until, Stream<T> source, Function<? super S, Integer> step, int maxReplay) {
        this.factory = factory;
        this.accumulator = accumulator;
        this.condition = condition;
        this.emitRemainder = emitRemainder;
        this.until = until;
        this.source = source;
        this.step = step;
        this.maxReplay = maxReplay;
    }

    private Buffer<S, T> createBuffer() {
        try {
            return new Buffer<S, T>(this.accumulator, this.factory.call());
        }
        catch (Exception e) {
            return (Buffer)Exceptions.rethrow(e);
        }
    }

    @Override
    public StreamIterator<S> iterator() {
        return new StreamIterator<S>(){
            ReplayableStreamIterator<T> it;
            Buffer<S, T> buffer;
            Buffer<S, T> nextBuffer;
            boolean ready;
            {
                this.it = new ReplayableStreamIterator(BufferWithFactoryPredicateAndStep.this.source.iteratorNullChecked(), BufferWithFactoryPredicateAndStep.this.maxReplay);
                this.buffer = BufferWithFactoryPredicateAndStep.this.createBuffer();
                this.nextBuffer = BufferWithFactoryPredicateAndStep.this.createBuffer();
            }

            @Override
            public boolean hasNext() {
                this.loadNext();
                return this.ready;
            }

            @Override
            public S next() {
                this.loadNext();
                if (!this.ready) {
                    throw new NoSuchElementException();
                }
                Buffer current = this.buffer;
                this.buffer = this.nextBuffer;
                this.nextBuffer = BufferWithFactoryPredicateAndStep.this.createBuffer();
                this.ready = false;
                int offset = (Integer)BufferWithFactoryPredicateAndStep.this.step.applyUnchecked(current.state);
                int bufferSize = this.buffer.count;
                this.buffer.count = 0;
                try {
                    this.buffer.state = BufferWithFactoryPredicateAndStep.this.factory.call();
                }
                catch (Exception e) {
                    Exceptions.rethrow(e);
                }
                if (offset > current.count) {
                    int n = offset - current.count;
                    for (int i = 0; i < n - bufferSize && this.it.hasNext(); ++i) {
                        this.it.next();
                    }
                } else {
                    this.it.replay(current.count - offset + bufferSize);
                }
                return current.state;
            }

            @Override
            public void dispose() {
                this.it.dispose();
            }

            private void loadNext() {
                try {
                    while (!this.ready && this.it.hasNext()) {
                        Object t = this.it.nextNullChecked();
                        boolean b = BufferWithFactoryPredicateAndStep.this.condition.testUnchecked(this.buffer.state, t);
                        if (!BufferWithFactoryPredicateAndStep.this.until) {
                            if (b) {
                                this.buffer.add(t);
                                continue;
                            }
                            this.ready = true;
                            this.nextBuffer.add(t);
                            continue;
                        }
                        if (b) {
                            this.ready = true;
                        }
                        this.buffer.add(t);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                if (!this.ready) {
                    if (BufferWithFactoryPredicateAndStep.this.emitRemainder && !this.buffer.isEmpty()) {
                        this.ready = true;
                    }
                } else {
                    this.ready = true;
                }
            }
        };
    }

    private static final class Buffer<S, T> {
        private final BiFunction<? super S, ? super T, ? extends S> accumulator;
        S state;
        int count;

        Buffer(BiFunction<? super S, ? super T, ? extends S> accumulator, S state) {
            this.accumulator = accumulator;
            this.state = state;
        }

        boolean isEmpty() {
            return this.count == 0;
        }

        void add(T t) throws Exception {
            ++this.count;
            this.state = this.accumulator.apply(this.state, t);
        }
    }
}

