/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import com.github.davidmoten.guavamini.Preconditions;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;

public class FromArray<T>
implements Stream<T> {
    private final T[] array;
    private final int fromIndex;
    private final int toIndex;

    public FromArray(T[] array, int fromIndex, int toIndex) {
        Preconditions.checkArgument((fromIndex >= 0 && fromIndex <= toIndex ? 1 : 0) != 0);
        Preconditions.checkArgument((toIndex <= array.length ? 1 : 0) != 0);
        this.array = array;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    @Override
    public StreamIterator<T> iterator() {
        return new StreamIterator<T>(){
            int i;
            {
                this.i = FromArray.this.fromIndex;
            }

            @Override
            public boolean hasNext() {
                return this.i < FromArray.this.toIndex;
            }

            @Override
            public T next() {
                return Preconditions.checkNotNull((Object)FromArray.this.array[this.i++]);
            }

            @Override
            public void dispose() {
            }
        };
    }
}

