/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import com.github.davidmoten.guavamini.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.NoSuchElementException;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;

public final class FromInputStream
implements Stream<ByteBuffer> {
    private InputStream is;
    private final int bufferSize;

    public FromInputStream(InputStream is, int bufferSize) {
        Preconditions.checkNotNull((Object)is);
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0);
        this.is = is;
        this.bufferSize = bufferSize;
    }

    @Override
    public StreamIterator<ByteBuffer> iterator() {
        return new StreamIterator<ByteBuffer>(){
            ByteBuffer next;

            @Override
            public boolean hasNext() {
                this.load();
                return this.next != null;
            }

            @Override
            public ByteBuffer next() {
                this.load();
                ByteBuffer v = this.next;
                if (v == null) {
                    throw new NoSuchElementException();
                }
                this.next = null;
                return v;
            }

            @Override
            public void dispose() {
                if (FromInputStream.this.is != null) {
                    FromInputStream.this.is = null;
                    this.next = null;
                }
            }

            private void load() {
                if (FromInputStream.this.is != null && this.next == null) {
                    int n;
                    byte[] b = new byte[FromInputStream.this.bufferSize];
                    try {
                        n = FromInputStream.this.is.read(b);
                    }
                    catch (IOException e) {
                        FromInputStream.this.is = null;
                        throw new UncheckedIOException(e);
                    }
                    if (n == -1) {
                        FromInputStream.this.is = null;
                        this.next = null;
                    } else {
                        this.next = ByteBuffer.wrap(b, 0, n);
                    }
                }
            }
        };
    }
}

