/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import java.io.IOException;
import java.io.Reader;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.internal.util.Exceptions;

public final class FromReader
implements Stream<String> {
    private final Reader reader;
    private final int bufferSize;

    public FromReader(Reader reader, int bufferSize) {
        this.reader = reader;
        this.bufferSize = bufferSize;
    }

    @Override
    public StreamIterator<String> iterator() {
        return new StreamIterator<String>(){
            char[] chars;
            int n;
            {
                this.chars = new char[FromReader.this.bufferSize];
            }

            @Override
            public boolean hasNext() {
                this.load();
                return this.n != -1;
            }

            @Override
            public String next() {
                this.load();
                int len = this.n;
                this.n = 0;
                return new String(this.chars, 0, len);
            }

            @Override
            public void dispose() {
            }

            private void load() {
                if (this.n == 0) {
                    try {
                        this.n = FromReader.this.reader.read(this.chars);
                    }
                    catch (IOException e) {
                        Exceptions.rethrow(e);
                        return;
                    }
                }
            }
        };
    }
}

