/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterable;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.Function;

public final class Map<T, R>
implements Stream<R> {
    private final Function<? super T, ? extends R> function;
    private final StreamIterable<T> source;

    public Map(Function<? super T, ? extends R> function, StreamIterable<T> source) {
        this.function = function;
        this.source = source;
    }

    @Override
    public StreamIterator<R> iterator() {
        return new StreamIterator<R>(){
            StreamIterator<T> it;
            {
                this.it = Map.this.source.iteratorNullChecked();
            }

            @Override
            public boolean hasNext() {
                return this.it != null && this.it.hasNext();
            }

            @Override
            public R next() {
                return Map.this.function.applyUnchecked(this.it.nextNullChecked());
            }

            @Override
            public void dispose() {
                if (this.it != null) {
                    this.it.dispose();
                    this.it = null;
                }
            }
        };
    }
}

