/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import com.github.davidmoten.guavamini.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.exceptions.CompositeException;
import org.davidmoten.kool.internal.util.Exceptions;

public final class MergeInterleaved<T>
implements Stream<T> {
    private final Stream<? extends T>[] streams;

    @SafeVarargs
    public MergeInterleaved(Stream<? extends T> ... streams) {
        this.streams = streams;
    }

    @Override
    public StreamIterator<T> iterator() {
        return new StreamIterator<T>(){
            List<StreamIterator<? extends T>> list;
            int index;
            T next;
            {
                this.list = MergeInterleaved.getIterators(MergeInterleaved.this.streams);
                this.index = 0;
            }

            @Override
            public boolean hasNext() {
                this.load();
                return this.next != null;
            }

            @Override
            public T next() {
                this.load();
                Object v = this.next;
                if (v == null) {
                    throw new NoSuchElementException();
                }
                this.next = null;
                return v;
            }

            @Override
            public void dispose() {
                if (this.list != null) {
                    try {
                        List<Throwable> errors = this.getDisposalErrors();
                        throw new CompositeException(errors);
                    }
                    catch (Throwable throwable) {
                        this.list = null;
                        throw throwable;
                    }
                }
            }

            private List<Throwable> getDisposalErrors() {
                ArrayList errors = Lists.newArrayList();
                for (StreamIterator it : this.list) {
                    try {
                        it.dispose();
                    }
                    catch (Throwable e) {
                        errors.add(e);
                    }
                }
                return errors;
            }

            private void load() {
                if (this.list != null && !this.list.isEmpty() && this.next == null) {
                    while (true) {
                        StreamIterator it;
                        if ((it = this.list.get(this.index)).hasNext()) {
                            this.next = it.nextNullChecked();
                            this.index = (this.index + 1) % this.list.size();
                            break;
                        }
                        int idx = this.list.indexOf(it);
                        this.list.remove(idx);
                        try {
                            it.dispose();
                        }
                        catch (Throwable e) {
                            List<Throwable> errors = this.getDisposalErrors();
                            if (errors.isEmpty()) {
                                Exceptions.rethrow(e);
                                return;
                            }
                            errors.add(e);
                            throw new CompositeException(errors);
                        }
                        if (this.list.isEmpty()) {
                            this.list = null;
                            break;
                        }
                        if (this.index < idx) continue;
                        this.index %= this.list.size();
                    }
                }
            }
        };
    }

    static <T> List<StreamIterator<? extends T>> getIterators(Stream<? extends T>[] streams) {
        ArrayList list = Lists.newArrayList();
        for (Stream<T> stream : streams) {
            list.add(stream.iteratorNullChecked());
        }
        return list;
    }
}

