/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import java.util.NoSuchElementException;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;

public final class Repeat<T>
implements Stream<T> {
    private final long count;
    private final Stream<T> source;

    public Repeat(long count, Stream<T> source) {
        this.count = count;
        this.source = source;
    }

    @Override
    public StreamIterator<T> iterator() {
        return new StreamIterator<T>(){
            StreamIterator<T> it;
            long i;
            {
                this.it = Repeat.this.source.iteratorNullChecked();
                this.i = 0L;
            }

            @Override
            public boolean hasNext() {
                if (this.it == null) {
                    return false;
                }
                while (!this.it.hasNext()) {
                    ++this.i;
                    if (this.i == Repeat.this.count) {
                        return false;
                    }
                    this.it = Repeat.this.source.iteratorNullChecked();
                }
                return true;
            }

            @Override
            public T next() {
                if (this.it == null) {
                    throw new NoSuchElementException();
                }
                return this.it.nextNullChecked();
            }

            @Override
            public void dispose() {
                if (this.it != null) {
                    this.it.dispose();
                    this.it = null;
                }
            }
        };
    }
}

