/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.internal.util.RingBuffer;

public final class ReplayableStreamIterator<T>
implements StreamIterator<T> {
    private final StreamIterator<T> it;
    private final RingBuffer<T> buffer;

    public ReplayableStreamIterator(StreamIterator<T> it, int maxReplay) {
        this.it = it;
        this.buffer = new RingBuffer(maxReplay);
    }

    @Override
    public boolean hasNext() {
        return !this.buffer.isEmpty() || this.it.hasNext();
    }

    @Override
    public T next() {
        if (this.buffer.isEmpty()) {
            this.buffer.add(this.it.next());
        }
        return this.buffer.poll();
    }

    @Override
    public void dispose() {
        this.it.dispose();
    }

    public void replay(int count) {
        this.buffer.replay(count);
    }
}

