/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.davidmoten.kool.Single;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.Function;
import org.davidmoten.kool.function.Predicate;
import org.davidmoten.kool.internal.util.Exceptions;

public final class RetryWhen<T>
implements Stream<T> {
    private final Stream<T> stream;
    private final Function<? super Throwable, ? extends Single<?>> function;

    public RetryWhen(Stream<T> stream, Function<? super Throwable, ? extends Single<?>> function) {
        this.stream = stream;
        this.function = function;
    }

    @Override
    public StreamIterator<T> iterator() {
        return new StreamIterator<T>(){
            StreamIterator<T> it;
            T next;
            boolean finished;

            @Override
            public boolean hasNext() {
                this.load();
                return this.next != null;
            }

            @Override
            public T next() {
                this.load();
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object v = this.next;
                this.next = null;
                return v;
            }

            public void load() {
                if (!this.finished && this.next == null) {
                    while (true) {
                        try {
                            if (this.it == null) {
                                this.it = RetryWhen.this.stream.iteratorNullChecked();
                            }
                            if (this.it.hasNext()) {
                                this.next = this.it.nextNullChecked();
                                break;
                            }
                            this.finished = true;
                        }
                        catch (Throwable e) {
                            ((Single)RetryWhen.this.function.applyUnchecked(e)).get();
                            try {
                                this.dispose();
                            }
                            catch (Throwable t) {
                                ((Single)RetryWhen.this.function.applyUnchecked(e)).get();
                            }
                            continue;
                        }
                        break;
                    }
                }
            }

            @Override
            public void dispose() {
                if (this.it != null) {
                    this.it.dispose();
                    this.it = null;
                    this.next = null;
                }
            }
        };
    }

    public static <T> Stream<T> build(Stream<T> stream, Stream<Long> delays, int maxRetries, Predicate<? super Throwable> predicate) {
        return Stream.defer(() -> {
            int[] retryNumber = new int[1];
            StreamIterator delaysIt = delays == null ? null : delays.iteratorNullChecked();
            Function<Throwable, Single> function = e -> {
                retryNumber[0] = retryNumber[0] + 1;
                if (maxRetries > 0 && retryNumber[0] > maxRetries) {
                    return (Single)Exceptions.rethrow(e);
                }
                if (predicate != null && !predicate.test((Throwable)e)) {
                    return (Single)Exceptions.rethrow(e);
                }
                if (delaysIt != null) {
                    if (delaysIt.hasNext()) {
                        long ms = (Long)delaysIt.nextNullChecked();
                        return Single.timer(ms, TimeUnit.MILLISECONDS);
                    }
                    return (Single)Exceptions.rethrow(e);
                }
                return Single.of(1);
            };
            return new RetryWhen(stream, function);
        });
    }
}

