/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;

public final class Reverse<T>
implements Stream<T> {
    private final Stream<T> stream;

    public Reverse(Stream<T> stream) {
        this.stream = stream;
    }

    @Override
    public StreamIterator<T> iterator() {
        return new StreamIterator<T>(){
            StreamIterator<T> it;
            final LinkedList<T> list;
            {
                this.it = Reverse.this.stream.iteratorNullChecked();
                this.list = new LinkedList();
            }

            @Override
            public boolean hasNext() {
                this.load();
                return !this.list.isEmpty();
            }

            @Override
            public T next() {
                this.load();
                if (this.list.isEmpty()) {
                    throw new NoSuchElementException();
                }
                return this.list.removeLast();
            }

            @Override
            public void dispose() {
                if (this.it != null) {
                    this.it.dispose();
                    this.it = null;
                    this.list.clear();
                }
            }

            private void load() {
                if (this.it != null) {
                    while (this.it.hasNext()) {
                        this.list.add(this.it.nextNullChecked());
                    }
                    this.it.dispose();
                    this.it = null;
                }
            }
        };
    }
}

