/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import java.util.NoSuchElementException;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.Predicate;

public final class SkipUntil<T>
implements Stream<T> {
    private final Stream<T> stream;
    private final Predicate<? super T> predicate;
    private final boolean negate;

    public SkipUntil(Stream<T> stream, Predicate<? super T> predicate, boolean negate) {
        this.stream = stream;
        this.predicate = predicate;
        this.negate = negate;
    }

    @Override
    public StreamIterator<T> iterator() {
        return new StreamIterator<T>(){
            StreamIterator<T> it;
            T next;
            boolean nextPredicateValue;
            boolean foundFirst;
            {
                this.it = SkipUntil.this.stream.iteratorNullChecked();
            }

            @Override
            public boolean hasNext() {
                this.loadNext();
                return this.next != null && (this.foundFirst || this.nextPredicateValue);
            }

            private void loadNext() {
                if (this.it != null) {
                    if (this.foundFirst) {
                        if (this.next == null && this.it.hasNext()) {
                            this.next = this.it.nextNullChecked();
                        }
                    } else {
                        while ((this.next == null || !this.nextPredicateValue) && this.it.hasNext()) {
                            this.next = this.it.nextNullChecked();
                            this.nextPredicateValue = SkipUntil.this.predicate.testChecked(this.next);
                            if (!SkipUntil.this.negate) continue;
                            this.nextPredicateValue = !this.nextPredicateValue;
                        }
                        boolean bl = this.foundFirst = this.next != null && this.nextPredicateValue;
                        if (!this.foundFirst) {
                            this.dispose();
                        }
                    }
                }
            }

            @Override
            public T next() {
                this.loadNext();
                if (!this.foundFirst) {
                    throw new NoSuchElementException();
                }
                Object v = this.next;
                this.next = null;
                return v;
            }

            @Override
            public void dispose() {
                if (this.it != null) {
                    this.next = null;
                    this.it.dispose();
                    this.it = null;
                }
            }
        };
    }
}

