/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import com.github.davidmoten.guavamini.Preconditions;
import java.util.concurrent.Callable;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.internal.util.Exceptions;

public final class SwitchOnEmpty<T>
implements Stream<T> {
    private final Stream<T> stream;
    private Callable<? extends Stream<T>> factory;

    public SwitchOnEmpty(Stream<T> stream, Callable<? extends Stream<T>> factory) {
        this.stream = stream;
        this.factory = factory;
    }

    @Override
    public StreamIterator<T> iterator() {
        return new StreamIterator<T>(){
            StreamIterator<T> it;
            boolean checkedForEmpty;
            {
                this.it = SwitchOnEmpty.this.stream.iterator();
            }

            @Override
            public boolean hasNext() {
                this.check();
                return this.it.hasNext();
            }

            @Override
            public T next() {
                this.check();
                return this.it.nextNullChecked();
            }

            @Override
            public void dispose() {
                if (this.it != null) {
                    this.it.dispose();
                    this.it = null;
                }
            }

            private void check() {
                if (!this.checkedForEmpty) {
                    this.checkedForEmpty = true;
                    if (!this.it.hasNext()) {
                        this.it.dispose();
                        try {
                            this.it = (StreamIterator)Preconditions.checkNotNull((Object)((Stream)SwitchOnEmpty.this.factory.call()).iterator());
                        }
                        catch (Exception e) {
                            Exceptions.rethrow(e);
                            return;
                        }
                    }
                }
            }
        };
    }
}

