/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.operators.stream;

import com.github.davidmoten.guavamini.Preconditions;
import java.util.NoSuchElementException;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterable;
import org.davidmoten.kool.StreamIterator;

public final class Take<T>
implements Stream<T> {
    private final long n;
    private final StreamIterable<T> source;

    public Take(long n, StreamIterable<T> source) {
        this.n = n;
        this.source = source;
    }

    @Override
    public StreamIterator<T> iterator() {
        return new StreamIterator<T>(){
            final StreamIterator<T> it;
            int count;
            {
                this.it = Take.this.source.iteratorNullChecked();
            }

            @Override
            public boolean hasNext() {
                return (long)this.count < Take.this.n && (Boolean)Preconditions.checkNotNull((Object)this.it.hasNext()) != false;
            }

            @Override
            public T next() {
                if ((long)this.count == Take.this.n || !this.it.hasNext()) {
                    this.it.dispose();
                    throw new NoSuchElementException();
                }
                ++this.count;
                return this.it.next();
            }

            @Override
            public void dispose() {
                this.it.dispose();
            }
        };
    }
}

