/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.kool.internal.util;

import com.github.davidmoten.guavamini.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.davidmoten.kool.Stream;
import org.davidmoten.kool.StreamIterable;
import org.davidmoten.kool.StreamIterator;
import org.davidmoten.kool.function.BiFunction;
import org.davidmoten.kool.function.Function;

public final class StreamUtils {
    private static final BiFunction<List<Object>, Object, List<Object>> LIST_ACCUMULATOR = (list, t) -> {
        list.add(t);
        return list;
    };

    private StreamUtils() {
    }

    public static <T> StreamIterator<T> iterator(StreamIterable<T> iter) {
        return (StreamIterator)Preconditions.checkNotNull((Object)iter.iterator(), (String)"iterator cannot be null");
    }

    public static <T> T next(StreamIterator<T> it) {
        return (T)Preconditions.checkNotNull(it.next(), (String)"upstream cannot emit null");
    }

    public static InputStream toInputStream(final Stream<? extends byte[]> stream) {
        return new InputStream(){
            StreamIterator<? extends byte[]> it;
            byte[] bytes;
            int index;
            {
                this.it = stream.iteratorNullChecked();
                this.bytes = new byte[0];
            }

            @Override
            public int read() throws IOException {
                this.load();
                if (this.bytes == null) {
                    return -1;
                }
                return this.bytes[this.index++] & 0xFF;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                this.load();
                if (this.bytes == null) {
                    return -1;
                }
                int length = Math.min(len, this.bytes.length - this.index);
                System.arraycopy(this.bytes, this.index, b, off, length);
                this.index += length;
                return length;
            }

            private void load() {
                if (this.bytes != null && this.index == this.bytes.length) {
                    while (this.it.hasNext()) {
                        this.bytes = this.it.nextNullChecked();
                        if (this.bytes.length <= 0) continue;
                        this.index = 0;
                        return;
                    }
                    this.bytes = null;
                    this.it.dispose();
                }
            }
        };
    }

    public static <T> BiFunction<List<T>, T, List<T>> listAccumulator() {
        return LIST_ACCUMULATOR;
    }

    public static final class FunctionIdentityHolder {
        public static final Function<Object, Object> IDENTITY = x -> x;
    }

    public static final class EmptyHolder {
        public static final Stream<Object> EMPTY = Stream.create(Collections.emptyList());
    }
}

