/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.odata.client.generator;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class Imports {
    private final String fullClassName;
    private final Map<String, String> map = new HashMap<String, String>();

    Imports(String fullClassName) {
        this.fullClassName = fullClassName;
        this.add(fullClassName);
    }

    public String add(Class<?> cls) {
        return this.add(cls.getCanonicalName().replace("$", "."));
    }

    public String add(String className) {
        String simpleName = Imports.simpleName(className);
        String c = this.map.get(simpleName);
        if (c == null) {
            this.map.put(simpleName, className);
            return simpleName;
        }
        if (c.equals(className)) {
            return simpleName;
        }
        return className;
    }

    private static String simpleName(String className) {
        int i = className.lastIndexOf(46);
        String simpleName = i == -1 ? className : className.substring(i + 1);
        return simpleName;
    }

    public String toString() {
        String pkgFullClassName = Imports.pkg(this.fullClassName);
        String x = this.map.values().stream().sorted().filter(c -> !c.startsWith("java.lang.")).filter(c -> !c.equals("boolean")).filter(c -> !c.equals("short")).filter(c -> !c.equals("float")).filter(c -> !c.equals("double")).filter(c -> !c.equals("int")).filter(c -> !c.equals("byte")).filter(c -> !c.equals(this.fullClassName)).filter(c -> !Imports.pkg(c).equals(pkgFullClassName)).map(new Function<String, String>(){
            String previous;

            @Override
            public String apply(String c) {
                String firstSegment = Imports.firstSegment(c);
                boolean insertBlankLine = this.previous != null && !firstSegment.equals(this.previous);
                this.previous = firstSegment;
                return (insertBlankLine ? "\n" : "") + "import " + c + ";";
            }
        }).collect(Collectors.joining("\n"));
        if (!x.isEmpty()) {
            x = x + "\n\n";
        }
        return x;
    }

    private static String pkg(String fullClassName) {
        int i = fullClassName.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return fullClassName.substring(0, i);
    }

    private static String firstSegment(String s) {
        int i = s.indexOf(46);
        if (i == -1) {
            return s;
        }
        return s.substring(0, i);
    }
}

