/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.odata.client.generator.model;

import com.github.davidmoten.odata.client.generator.Imports;
import com.github.davidmoten.odata.client.generator.Names;
import com.github.davidmoten.odata.client.generator.Util;
import com.github.davidmoten.odata.client.generator.model.HasNameJavaHasNullable;
import com.github.davidmoten.odata.client.generator.model.Method;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.oasisopen.odata.csdl.v4.Schema;
import org.oasisopen.odata.csdl.v4.TAction;
import org.oasisopen.odata.csdl.v4.TActionFunctionParameter;
import org.oasisopen.odata.csdl.v4.TActionFunctionReturnType;

public final class Action
implements Method {
    private final TAction action;
    private final Names names;

    public Action(TAction action, Names names) {
        this.action = action;
        this.names = names;
    }

    public Schema schema() {
        return this.names.getSchema(this.action);
    }

    public String getFullClassNameActionReturnType() {
        Optional<TActionFunctionReturnType> returnParameter = Util.filter(this.action.getParameterOrAnnotationOrReturnType(), TActionFunctionReturnType.class).findFirst();
        if (!returnParameter.isPresent()) {
            return Void.class.getName();
        }
        return this.names.getFullClassNameFromTypeWithNamespace(this.names.getInnerType(returnParameter.get()));
    }

    public Optional<String> getActionReturnType() {
        return Util.filter(this.action.getParameterOrAnnotationOrReturnType(), TActionFunctionReturnType.class).map(this.names::getInnerType).findFirst();
    }

    @Override
    public Optional<String> getBoundTypeWithNamespace() {
        if (!this.action.isIsBound()) {
            return Optional.empty();
        }
        return Util.filter(this.action.getParameterOrAnnotationOrReturnType(), TActionFunctionParameter.class).map(this.names::getInnerType).findFirst();
    }

    @Override
    public String getName() {
        return this.action.getName();
    }

    public String getActionMethodName() {
        return Names.getIdentifier(this.action.getName());
    }

    public List<Parameter> getParametersUnbound(Imports imports) {
        AtomicBoolean first = new AtomicBoolean(true);
        return Util.filter(this.action.getParameterOrAnnotationOrReturnType(), TActionFunctionParameter.class).filter(x -> !this.action.isIsBound() || !first.getAndSet(false)).map(x -> new Parameter((TActionFunctionParameter)x, this.names, imports)).collect(Collectors.toList());
    }

    public boolean hasReturnType() {
        return Util.filter(this.action.getParameterOrAnnotationOrReturnType(), TActionFunctionReturnType.class).findFirst().isPresent();
    }

    public ReturnType getReturnType(Imports imports) {
        return Util.filter(this.action.getParameterOrAnnotationOrReturnType(), TActionFunctionReturnType.class).findFirst().map(x -> {
            String innerType = this.names.getInnerType((TActionFunctionReturnType)x);
            String schemaInfoClassName = innerType.startsWith("Edm.") ? EdmSchemaInfo.INSTANCE.getClass().getCanonicalName() : this.names.getFullClassNameSchemaInfo(this.names.getSchema(innerType));
            return new ReturnType(innerType, this.names.isCollection((TActionFunctionReturnType)x), this.names.toImportedTypeNonCollection(this.names.getInnerType((TActionFunctionReturnType)x), imports), schemaInfoClassName);
        }).get();
    }

    public String getFullType() {
        return this.names.getFullTypeFromSimpleType(this.schema(), this.action.getName());
    }

    @Override
    public boolean isBoundToCollection() {
        return this.getBoundType().map(Names::isCollection).orElse(false);
    }

    @Override
    public Optional<String> getBoundType() {
        if (!this.action.isIsBound()) {
            return Optional.empty();
        }
        TActionFunctionParameter p = Util.filter(this.action.getParameterOrAnnotationOrReturnType(), TActionFunctionParameter.class).findFirst().get();
        return Optional.of(p.getType().get(0));
    }

    public static final class ReturnType {
        public final String innerImportedFullClassName;
        public final boolean isCollection;
        public final String schemaInfoFullClassName;
        public final String innerType;

        public ReturnType(String innerType, boolean isCollection, String innerImportedFullClassName, String schemaInfoFullClassName) {
            this.innerType = innerType;
            this.isCollection = isCollection;
            this.innerImportedFullClassName = innerImportedFullClassName;
            this.schemaInfoFullClassName = schemaInfoFullClassName;
        }
    }

    public static final class Parameter
    implements HasNameJavaHasNullable {
        public final String name;
        private final String nameJava;
        public final String importedFullClassName;
        public final boolean isCollection;
        public final String typeWithNamespace;
        private final boolean isNullable;
        private final boolean isAscii;

        public Parameter(TActionFunctionParameter p, Names names, Imports imports) {
            this.name = p.getName();
            this.nameJava = Names.getIdentifier(p.getName());
            this.importedFullClassName = names.toImportedFullClassName(p, imports);
            this.isCollection = names.isCollection(p);
            this.typeWithNamespace = p.getType().get(0);
            this.isNullable = p.isNullable() == null ? true : p.isNullable();
            this.isAscii = p.isUnicode() != null && p.isUnicode() == false;
        }

        @Override
        public String nameJava() {
            return this.nameJava;
        }

        @Override
        public boolean isNullable() {
            return this.isNullable;
        }

        public boolean isAscii() {
            return this.isAscii;
        }
    }
}

