/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.odata.client.generator.model;

import com.github.davidmoten.odata.client.generator.Imports;
import com.github.davidmoten.odata.client.generator.Names;
import com.github.davidmoten.odata.client.generator.Util;
import java.io.File;
import org.oasisopen.odata.csdl.v4.Schema;
import org.oasisopen.odata.csdl.v4.TEntityContainer;
import org.oasisopen.odata.csdl.v4.TEntitySet;
import org.oasisopen.odata.csdl.v4.TNavigationPropertyBinding;

public final class EntitySet {
    private final Schema schema;
    private final TEntityContainer container;
    private final TEntitySet entitySet;
    private final Names names;

    public EntitySet(Schema schema, TEntityContainer container, TEntitySet entitySet, Names names) {
        this.schema = schema;
        this.container = container;
        this.entitySet = entitySet;
        this.names = names;
    }

    public String getFullClassNameEntitySet() {
        return this.getPackage() + "." + this.getSimpleClassNameEntitySet();
    }

    public String getPackage() {
        return this.names.getPackageEntitySet(this.schema);
    }

    public String getSimpleClassNameEntitySet() {
        return Names.toSimpleClassName(this.entitySet.getName());
    }

    public File getClassFile() {
        return this.names.getClassFileEntitySet(this.schema, this.entitySet.getName());
    }

    public File getDirectoryEntitySet() {
        return this.names.getDirectoryEntitySet(this.schema);
    }

    public String getBaseCollectionRequestClassName(Imports imports) {
        String t = this.entitySet.getEntityType();
        Schema schema = this.names.getSchema(t);
        return imports.add(this.names.getFullClassNameCollectionRequestFromTypeWithNamespace(schema, t));
    }

    public EntitySet getReferredEntitySet(String name) {
        return Util.filter(this.container.getEntitySetOrActionImportOrFunctionImport(), TEntitySet.class).filter(x -> x.getName().equals(name)).map(es -> new EntitySet(this.schema, this.container, (TEntitySet)es, this.names)).findFirst().orElseGet(() -> (EntitySet)this.names.getSchemas().stream().flatMap(sch -> Util.types(sch, TEntityContainer.class).flatMap(c -> Util.filter(c.getEntitySetOrActionImportOrFunctionImport(), TEntitySet.class).filter(es -> name.equals(sch.getNamespace() + "." + c.getName() + "/" + es.getName())).map(es -> new EntitySet((Schema)sch, (TEntityContainer)c, (TEntitySet)es, this.names)))).findFirst().orElseThrow(() -> new RuntimeException("EntitySet " + name + " not found")));
    }

    public String getMethodName(TNavigationPropertyBinding b) {
        return Names.getIdentifier(EntitySet.lastSegment(b.getPath()));
    }

    public String getSimplifiedPath(TNavigationPropertyBinding b) {
        return EntitySet.lastSegment(b.getPath());
    }

    private static String lastSegment(String s) {
        int i = s.lastIndexOf("/");
        if (i == -1) {
            return s;
        }
        return s.substring(i + 1);
    }
}

