/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.odata.client.generator.model;

import com.github.davidmoten.odata.client.generator.Imports;
import com.github.davidmoten.odata.client.generator.Names;
import com.github.davidmoten.odata.client.generator.Util;
import com.github.davidmoten.odata.client.generator.model.HasNameJavaHasNullable;
import com.github.davidmoten.odata.client.generator.model.Method;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.oasisopen.odata.csdl.v4.Schema;
import org.oasisopen.odata.csdl.v4.TActionFunctionParameter;
import org.oasisopen.odata.csdl.v4.TActionFunctionReturnType;
import org.oasisopen.odata.csdl.v4.TFunction;

public final class Function
implements Method {
    private final TFunction function;
    private final Names names;

    public Function(TFunction function, Names names) {
        this.function = function;
        this.names = names;
    }

    public Schema schema() {
        return this.names.getSchema(this.function);
    }

    public String getFullClassNameActionReturnType() {
        Optional<TActionFunctionReturnType> returnParameter = Util.filter(this.function.getParameterOrAnnotation(), TActionFunctionReturnType.class).findFirst();
        if (!returnParameter.isPresent()) {
            return Void.class.getName();
        }
        return this.names.getFullClassNameFromTypeWithNamespace(this.names.getInnerType(returnParameter.get()));
    }

    public String getFunctionReturnType() {
        return this.names.getInnerType(this.function.getReturnType());
    }

    @Override
    public Optional<String> getBoundTypeWithNamespace() {
        if (!this.function.isIsBound()) {
            return Optional.empty();
        }
        return Util.filter(this.function.getParameterOrAnnotation(), TActionFunctionParameter.class).map(this.names::getInnerType).findFirst();
    }

    @Override
    public String getName() {
        return this.function.getName();
    }

    public String getActionMethodName() {
        return Names.getIdentifier(this.function.getName());
    }

    public List<Parameter> getParametersUnbound(Imports imports) {
        AtomicBoolean first = new AtomicBoolean(true);
        return Util.filter(this.function.getParameterOrAnnotation(), TActionFunctionParameter.class).filter(x -> !this.function.isIsBound() || !first.getAndSet(false)).map(x -> new Parameter((TActionFunctionParameter)x, this.names, imports)).collect(Collectors.toList());
    }

    public ReturnType getReturnType(Imports imports) {
        String innerType = this.names.getInnerType(this.function.getReturnType());
        return new ReturnType(innerType, this.names.isCollection(this.function.getReturnType()), this.names.toImportedTypeNonCollection(this.names.getInnerType(this.function.getReturnType()), imports));
    }

    public String getFullType() {
        return this.names.getFullTypeFromSimpleType(this.schema(), this.function.getName());
    }

    @Override
    public boolean isBoundToCollection() {
        return this.getBoundType().map(Names::isCollection).orElse(false);
    }

    @Override
    public Optional<String> getBoundType() {
        if (!this.function.isIsBound()) {
            return Optional.empty();
        }
        TActionFunctionParameter p = Util.filter(this.function.getParameterOrAnnotation(), TActionFunctionParameter.class).findFirst().get();
        return Optional.of(p.getType().get(0));
    }

    public static final class ReturnType {
        public final String innerType;
        public final String innerImportedFullClassName;
        public final boolean isCollection;

        public ReturnType(String innerType, boolean isCollection, String innerImportedFullClassName) {
            this.innerType = innerType;
            this.isCollection = isCollection;
            this.innerImportedFullClassName = innerImportedFullClassName;
        }
    }

    public static final class Parameter
    implements HasNameJavaHasNullable {
        public final String name;
        private final String nameJava;
        public final String importedFullClassName;
        public final boolean isCollection;
        public final String typeWithNamespace;
        private final boolean isNullable;
        private final boolean isAscii;

        public Parameter(TActionFunctionParameter p, Names names, Imports imports) {
            this.name = p.getName();
            this.nameJava = Names.getIdentifier(p.getName());
            this.importedFullClassName = names.toImportedFullClassName(p, imports);
            this.isCollection = names.isCollection(p);
            this.typeWithNamespace = p.getType().get(0);
            this.isNullable = p.isNullable() == null ? false : p.isNullable();
            this.isAscii = p.isUnicode() != null && p.isUnicode() == false;
        }

        @Override
        public String nameJava() {
            return this.nameJava;
        }

        @Override
        public boolean isNullable() {
            return this.isNullable;
        }

        public boolean isAscii() {
            return this.isAscii;
        }
    }
}

