/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.odata.client.generator;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Lists;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.Context;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.Enum;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.FunctionRequestReturningStream;
import com.github.davidmoten.odata.client.HasContext;
import com.github.davidmoten.odata.client.HttpMethod;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.HttpService;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Path;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.SchemaInfo;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.StreamUploader;
import com.github.davidmoten.odata.client.StreamUploaderChunked;
import com.github.davidmoten.odata.client.StreamUploaderSingleCall;
import com.github.davidmoten.odata.client.TestingService;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.UploadStrategy;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.generator.Imports;
import com.github.davidmoten.odata.client.generator.Indent;
import com.github.davidmoten.odata.client.generator.Names;
import com.github.davidmoten.odata.client.generator.Options;
import com.github.davidmoten.odata.client.generator.model.Action;
import com.github.davidmoten.odata.client.generator.model.ComplexType;
import com.github.davidmoten.odata.client.generator.model.EntitySet;
import com.github.davidmoten.odata.client.generator.model.EntityType;
import com.github.davidmoten.odata.client.generator.model.Field;
import com.github.davidmoten.odata.client.generator.model.Function;
import com.github.davidmoten.odata.client.generator.model.HasNameJavaHasNullable;
import com.github.davidmoten.odata.client.generator.model.KeyElement;
import com.github.davidmoten.odata.client.generator.model.Method;
import com.github.davidmoten.odata.client.generator.model.PropertyRef;
import com.github.davidmoten.odata.client.generator.model.Structure;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.oasisopen.odata.csdl.v4.Schema;
import org.oasisopen.odata.csdl.v4.TAction;
import org.oasisopen.odata.csdl.v4.TActionFunctionParameter;
import org.oasisopen.odata.csdl.v4.TActionFunctionReturnType;
import org.oasisopen.odata.csdl.v4.TComplexType;
import org.oasisopen.odata.csdl.v4.TEntityContainer;
import org.oasisopen.odata.csdl.v4.TEntitySet;
import org.oasisopen.odata.csdl.v4.TEntityType;
import org.oasisopen.odata.csdl.v4.TEnumType;
import org.oasisopen.odata.csdl.v4.TEnumTypeMember;
import org.oasisopen.odata.csdl.v4.TFunction;
import org.oasisopen.odata.csdl.v4.TNavigationProperty;
import org.oasisopen.odata.csdl.v4.TNavigationPropertyBinding;
import org.oasisopen.odata.csdl.v4.TProperty;
import org.oasisopen.odata.csdl.v4.TSingleton;

public final class Generator {
    private static final String COLLECTION_PREFIX = "Collection(";
    private final Names names;
    private final List<Schema> schemas;
    public static final int MAX_JAVADOC_WIDTH = 80;

    public Generator(Options options, List<Schema> schemas) {
        this.schemas = schemas;
        this.names = Names.create(schemas, options);
    }

    public void generate() {
        this.log("-----------------------------------");
        this.log("Generating code for namespaces:");
        this.schemas.forEach(s -> this.log("  " + s.getNamespace()));
        this.schemas.stream().flatMap(s -> com.github.davidmoten.odata.client.generator.Util.filter(s.getComplexTypeOrEntityTypeOrTypeDefinition(), TEntityType.class).map(t -> new Names.SchemaAndType<TEntityType>((Schema)s, (TEntityType)t))).map(x -> this.names.toTypeWithNamespace(x.schema, ((TEntityType)x.type).getName())).forEach(System.out::println);
        this.log("-----------------------------------");
        this.log("replacing aliases");
        com.github.davidmoten.odata.client.generator.Util.replaceAliases(this.schemas);
        this.log("finding collection types");
        Set<String> collectionTypes = Generator.findTypesUsedInCollections(this.names, this.schemas);
        for (Schema schema : this.schemas) {
            this.log("generating for namespace=" + schema.getNamespace());
            this.log("  creating maps");
            Map<String, List<Action>> typeActions = this.createTypeActions(schema, this.names, false);
            this.log("    entity actions count = " + typeActions.size());
            Map<String, List<Function>> typeFunctions = this.createTypeFunctions(schema, this.names, false);
            this.log("    entity functions count = " + typeFunctions.size());
            Map<String, List<Action>> collectionTypeActions = this.createTypeActions(schema, this.names, true);
            this.log("    collection actions count = " + collectionTypeActions.size());
            Map<String, List<Function>> collectionTypeFunctions = this.createTypeFunctions(schema, this.names, true);
            System.out.println("    collection functions count = " + collectionTypeFunctions.size());
            this.log("  checking entities have keys");
            com.github.davidmoten.odata.client.generator.Util.types(schema, TEntityType.class).map(x -> new EntityType((TEntityType)x, this.names)).filter(x -> !x.hasKey()).forEach(x -> this.log("    " + x.getFullType() + " has no keys"));
            this.log("  writing schema info");
            this.writeSchemaInfo(schema);
            this.log("  writing enums");
            com.github.davidmoten.odata.client.generator.Util.types(schema, TEnumType.class).forEach(x -> this.writeEnum(schema, (TEnumType)x));
            this.log("  writing entities");
            com.github.davidmoten.odata.client.generator.Util.types(schema, TEntityType.class).forEach(x -> this.writeEntity((TEntityType)x, typeActions, typeFunctions));
            this.log("  writing complex types");
            com.github.davidmoten.odata.client.generator.Util.types(schema, TComplexType.class).forEach(x -> this.writeComplexType(schema, (TComplexType)x));
            this.log("  writing entity collection requests");
            com.github.davidmoten.odata.client.generator.Util.types(schema, TEntityType.class).forEach(x -> this.writeEntityCollectionRequest(schema, (TEntityType)x, collectionTypeActions, collectionTypeFunctions, collectionTypes));
            this.log("writing entity set requests");
            com.github.davidmoten.odata.client.generator.Util.types(schema, TEntityContainer.class).flatMap(c -> com.github.davidmoten.odata.client.generator.Util.filter(c.getEntitySetOrActionImportOrFunctionImport(), TEntitySet.class).map(x -> new Pair<TEntityContainer, TEntitySet>((TEntityContainer)c, (TEntitySet)x))).forEach(x -> this.writeEntitySet(schema, (Pair<TEntityContainer, TEntitySet>)x));
            this.log("  writing container");
            com.github.davidmoten.odata.client.generator.Util.types(schema, TEntityContainer.class).forEach(x -> this.writeContainer(schema, (TEntityContainer)x));
            this.log("  writing entity requests");
            com.github.davidmoten.odata.client.generator.Util.types(schema, TEntityType.class).forEach(x -> this.writeEntityRequest(schema, (TEntityType)x, typeActions, typeFunctions));
            this.log("  writing complex type requests");
            com.github.davidmoten.odata.client.generator.Util.types(schema, TComplexType.class).forEach(x -> this.writeComplexTypeRequest(schema, (TComplexType)x));
        }
    }

    private void writeEntitySet(Schema schema, Pair<TEntityContainer, TEntitySet> pair) {
        EntitySet t = new EntitySet(schema, (TEntityContainer)pair.a, (TEntitySet)pair.b, this.names);
        t.getDirectoryEntitySet().mkdirs();
        Imports imports = new Imports(t.getFullClassNameEntitySet());
        Indent indent = new Indent();
        StringWriter w = new StringWriter();
        try (PrintWriter p = new PrintWriter(w);){
            p.format("package %s;\n\n", t.getPackage());
            p.format("IMPORTSHERE", new Object[0]);
            String baseCollectionClassName = t.getBaseCollectionRequestClassName(imports);
            p.format("%spublic final class %s extends %s {\n", indent, t.getSimpleClassNameEntitySet(), baseCollectionClassName);
            indent.right();
            p.format("\n%spublic %s(%s contextPath) {\n", indent, t.getSimpleClassNameEntitySet(), imports.add(ContextPath.class));
            p.format("%ssuper(contextPath, %s.empty());\n", indent.right(), imports.add(Optional.class));
            p.format("%s}\n", indent.left());
            Set<String> duplicateMethodNames = this.findDuplicateNavigationPropertyBindingMethodNames(pair, t);
            com.github.davidmoten.odata.client.generator.Util.filter(((TEntitySet)pair.b).getNavigationPropertyBindingOrAnnotation(), TNavigationPropertyBinding.class).forEach(b -> {
                Optional<EntitySet> referredEntitySet;
                String methodName = t.getMethodName((TNavigationPropertyBinding)b);
                if (duplicateMethodNames.contains(methodName)) {
                    methodName = t.getLongerMethodName((TNavigationPropertyBinding)b);
                }
                if ((referredEntitySet = t.getReferredEntitySet(b.getTarget())).isPresent()) {
                    String returnClassName = referredEntitySet.get().getFullClassNameEntitySet();
                    p.format("\n%spublic %s %s() {\n", indent, imports.add(returnClassName), methodName);
                    p.format("%sreturn new %s(contextPath.addSegment(\"%s\"));\n", indent.right(), imports.add(referredEntitySet.get().getFullClassNameEntitySet()), b.getPath());
                    p.format("%s}\n", indent.left());
                } else {
                    this.log("WARN: EntitySet '" + b.getTarget() + "' not found for navigation property binding " + t.getSimpleClassNameEntitySet() + "." + b.getPath());
                }
            });
            p.format("%s}\n", indent.left());
            this.writeToFile(imports, w, t.getClassFile());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Set<String> findDuplicateNavigationPropertyBindingMethodNames(Pair<TEntityContainer, TEntitySet> pair, EntitySet t) {
        HashSet methodNames = new HashSet();
        HashSet<String> duplicateMethodNames = new HashSet<String>();
        com.github.davidmoten.odata.client.generator.Util.filter(((TEntitySet)pair.b).getNavigationPropertyBindingOrAnnotation(), TNavigationPropertyBinding.class).forEach(b -> {
            String name = t.getMethodName((TNavigationPropertyBinding)b);
            if (methodNames.contains(name)) {
                duplicateMethodNames.add(name);
            }
            methodNames.add(name);
        });
        return duplicateMethodNames;
    }

    private static Set<String> findTypesUsedInCollections(Names names, List<Schema> schemas) {
        return schemas.stream().flatMap(schema -> {
            ArrayList types = new ArrayList();
            com.github.davidmoten.odata.client.generator.Util.types(schema, TEntityType.class).flatMap(t -> Stream.concat(com.github.davidmoten.odata.client.generator.Util.filter(t.getKeyOrPropertyOrNavigationProperty(), TProperty.class).filter(names::isCollection).map(names::getType), com.github.davidmoten.odata.client.generator.Util.filter(t.getKeyOrPropertyOrNavigationProperty(), TNavigationProperty.class).filter(names::isCollection).map(names::getType))).forEach(types::add);
            com.github.davidmoten.odata.client.generator.Util.types(schema, TComplexType.class).flatMap(t -> Stream.concat(com.github.davidmoten.odata.client.generator.Util.filter(t.getPropertyOrNavigationPropertyOrAnnotation(), TProperty.class).filter(names::isCollection).map(names::getType), com.github.davidmoten.odata.client.generator.Util.filter(t.getPropertyOrNavigationPropertyOrAnnotation(), TNavigationProperty.class).filter(names::isCollection).map(names::getType))).forEach(types::add);
            com.github.davidmoten.odata.client.generator.Util.types(schema, TAction.class).flatMap(t -> Stream.concat(com.github.davidmoten.odata.client.generator.Util.filter(t.getParameterOrAnnotationOrReturnType(), TActionFunctionParameter.class).filter(names::isCollection).map(names::getType), com.github.davidmoten.odata.client.generator.Util.filter(t.getParameterOrAnnotationOrReturnType(), TActionFunctionReturnType.class).filter(names::isCollection).map(names::getType))).forEach(types::add);
            com.github.davidmoten.odata.client.generator.Util.types(schema, TFunction.class).flatMap(t -> Stream.concat(com.github.davidmoten.odata.client.generator.Util.filter(t.getParameterOrAnnotation(), TActionFunctionParameter.class).filter(names::isCollection).map(names::getType), com.github.davidmoten.odata.client.generator.Util.filter(t.getParameterOrAnnotation(), TActionFunctionReturnType.class).filter(names::isCollection).map(names::getType))).forEach(types::add);
            com.github.davidmoten.odata.client.generator.Util.types(schema, TEntityContainer.class).flatMap(t -> com.github.davidmoten.odata.client.generator.Util.filter(t.getEntitySetOrActionImportOrFunctionImport(), TEntitySet.class)).flatMap(t -> Stream.concat(Stream.of(t.getEntityType()), com.github.davidmoten.odata.client.generator.Util.filter(t.getNavigationPropertyBindingOrAnnotation(), TNavigationPropertyBinding.class).map(TNavigationPropertyBinding::getPath))).forEach(types::add);
            return types.stream();
        }).map(names::getInnerType).collect(Collectors.toSet());
    }

    private void log(Object s) {
        System.out.println(s);
    }

    private Map<String, List<Action>> createTypeActions(Schema schema, Names names, boolean collectionsOnly) {
        return this.createMap(TAction.class, schema, names, action -> new Action((TAction)action, names), collectionsOnly);
    }

    private Map<String, List<Function>> createTypeFunctions(Schema schema, Names names, boolean collectionsOnly) {
        return this.createMap(TFunction.class, schema, names, function -> new Function((TFunction)function, names), collectionsOnly);
    }

    private <T, S extends Method> Map<String, List<S>> createMap(Class<T> cls, Schema schema, Names names, java.util.function.Function<T, S> mapper, boolean collectionsOnly) {
        HashMap map = new HashMap();
        com.github.davidmoten.odata.client.generator.Util.types(schema, cls).forEach(method -> {
            Method a = (Method)mapper.apply(method);
            if (!collectionsOnly && !a.isBoundToCollection() || collectionsOnly && a.isBoundToCollection()) {
                a.getBoundTypeWithNamespace().ifPresent(x -> {
                    List list = (List)map.get(x);
                    if (list == null) {
                        map.put((String)x, Lists.newArrayList((Object[])new Method[]{a}));
                    } else {
                        list.add(a);
                    }
                });
            }
        });
        return map;
    }

    private void writeComplexTypeRequest(Schema schema, TComplexType x) {
    }

    private void writeSchemaInfo(Schema schema) {
        this.names.getDirectorySchema(schema).mkdirs();
        String simpleClassName = this.names.getSimpleClassNameSchema(schema);
        Imports imports = new Imports(this.names.getFullClassNameSchema(schema));
        Indent indent = new Indent();
        try {
            StringWriter w = new StringWriter();
            try (PrintWriter p = new PrintWriter(w);){
                p.format("package %s;\n\n", this.names.getPackageSchema(schema));
                p.format("IMPORTSHERE", new Object[0]);
                p.format("public enum %s implements %s {\n\n", simpleClassName, imports.add(SchemaInfo.class));
                p.format("%sINSTANCE;\n\n", indent.right());
                p.format("%sprivate final %s<%s, %s<? extends %s>> classes = new %s<>();\n\n", indent, imports.add(Map.class), imports.add(String.class), imports.add(Class.class), imports.add(ODataType.class), imports.add(HashMap.class));
                p.format("%sprivate %s() {\n", indent, simpleClassName);
                indent.right();
                this.names.getSchemas().stream().flatMap(sch -> com.github.davidmoten.odata.client.generator.Util.filter(sch.getComplexTypeOrEntityTypeOrTypeDefinition(), TEntityType.class)).forEach(x -> {
                    Schema sch = this.names.getSchema((TEntityType)x);
                    p.format("%sclasses.put(\"%s\", %s.class);\n", indent, this.names.getFullTypeFromSimpleType(sch, x.getName()), imports.add(this.names.getFullClassNameEntity(sch, x.getName())));
                });
                this.names.getSchemas().stream().flatMap(sch -> com.github.davidmoten.odata.client.generator.Util.filter(sch.getComplexTypeOrEntityTypeOrTypeDefinition(), TComplexType.class)).forEach(x -> {
                    Schema sch = this.names.getSchema((TComplexType)x);
                    p.format("%sclasses.put(\"%s\", %s.class);\n", indent, this.names.getFullTypeFromSimpleType(sch, x.getName()), imports.add(this.names.getFullClassNameComplexType(sch, x.getName())));
                });
                indent.left();
                p.format("%s}\n\n", indent);
                p.format("%s@%s\n", indent, imports.add(Override.class));
                p.format("%spublic %s<? extends %s> getClassFromTypeWithNamespace(%s name) {\n", indent, imports.add(Class.class), imports.add(ODataType.class), imports.add(String.class));
                p.format("%sreturn classes.get(name);\n", indent.right());
                p.format("%s}\n\n", indent.left());
                p.format("}\n", new Object[0]);
            }
            byte[] bytes = w.toString().replace("IMPORTSHERE", imports.toString()).getBytes(StandardCharsets.UTF_8);
            Files.write(this.names.getClassFileSchema(schema).toPath(), bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void writeEnum(Schema schema, TEnumType t) {
        this.names.getDirectoryEnum(schema).mkdirs();
        String simpleClassName = this.names.getSimpleClassNameEnum(schema, t.getName());
        Imports imports = new Imports(this.names.getFullClassNameEnum(schema, t.getName()));
        Indent indent = new Indent();
        try {
            StringWriter w = new StringWriter();
            try (PrintWriter p = new PrintWriter(w);){
                p.format("package %s;\n\n", this.names.getPackageEnum(schema));
                p.format("IMPORTSHERE", new Object[0]);
                p.format("public enum %s implements %s {\n", simpleClassName, imports.add(Enum.class));
                indent.right();
                String s = com.github.davidmoten.odata.client.generator.Util.filter(t.getMemberOrAnnotation(), TEnumTypeMember.class).map(x -> String.format("%s@%s(\"%s\")\n%s%s(\"%s\", \"%s\")", indent, imports.add(JsonProperty.class), x.getName(), indent, this.names.getEnumInstanceName(t, x.getName()), x.getName(), x.getValue())).collect(Collectors.joining(",\n\n"));
                indent.left();
                p.format("\n%s;\n\n", s);
                p.format("%sprivate final %s name;\n", indent.right(), imports.add(String.class));
                p.format("%sprivate final %s value;\n\n", indent, imports.add(String.class));
                p.format("%sprivate %s(%s name, %s value) {\n", indent, simpleClassName, imports.add(String.class), imports.add(String.class));
                p.format("%sthis.name = name;\n", indent.right());
                p.format("%sthis.value = value;\n", indent);
                p.format("%s}\n\n", indent.left());
                p.format("%s@%s\n", indent, imports.add(Override.class));
                p.format("%spublic %s enumName() {\n", indent, imports.add(String.class));
                p.format("%sreturn name;\n", indent.right());
                p.format("%s}\n\n", indent.left());
                p.format("%s@%s\n", indent, imports.add(Override.class));
                p.format("%spublic %s enumValue() {\n", indent, imports.add(String.class));
                p.format("%sreturn value;\n", indent.right());
                p.format("%s}\n\n", indent.left());
                p.format("}\n", new Object[0]);
            }
            byte[] bytes = w.toString().replace("IMPORTSHERE", imports.toString()).getBytes(StandardCharsets.UTF_8);
            Files.write(this.names.getClassFileEnum(schema, t.getName()).toPath(), bytes, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeEntity(TEntityType entityType, Map<String, List<Action>> typeActions, Map<String, List<Function>> typeFunctions) {
        EntityType t = new EntityType(entityType, this.names);
        t.getDirectoryEntity().mkdirs();
        String simpleClassName = t.getSimpleClassName();
        Imports imports = new Imports(t.getFullClassNameEntity());
        Indent indent = new Indent();
        StringWriter w = new StringWriter();
        try (PrintWriter p = new PrintWriter(w);){
            p.format("package %s;\n\n", t.getPackage());
            p.format("IMPORTSHERE", new Object[0]);
            t.printJavadoc(p, indent);
            this.printPropertyOrder(imports, p, t.getProperties());
            Generator.printJsonIncludesNonNull(indent, imports, p);
            p.format("public class %s%s implements %s {\n", simpleClassName, t.getExtendsClause(imports), imports.add(ODataEntityType.class));
            indent.right();
            if (!t.hasBaseType()) {
                Generator.addContextPathInjectableField(imports, indent, p);
                Generator.addUnmappedFieldsField(imports, indent, p);
                Generator.addChangedFieldsField(imports, indent, p);
            }
            p.format("\n%s@%s\n", indent, imports.add(Override.class));
            p.format("%spublic String odataTypeName() {\n", indent);
            p.format("%sreturn \"%s\";\n", indent.right(), t.getFullType());
            p.format("%s}\n", indent.left());
            this.printPropertyFields(imports, indent, p, t.getProperties(), t.hasBaseType());
            this.writeNoArgsConstructor(simpleClassName, indent, p, t.hasBaseType());
            this.writeBuilder(t, simpleClassName, imports, indent, p);
            p.format("\n%s@%s\n", indent, imports.add(Override.class));
            p.format("%s@%s\n", indent, imports.add(JsonIgnore.class));
            p.format("%spublic %s getChangedFields() {\n", indent, imports.add(ChangedFields.class));
            p.format("%sreturn changedFields;\n", indent.right());
            p.format("%s}\n", indent.left());
            String nullCheck = Generator.fieldNames(t).stream().map(f -> f + " != null").collect(Collectors.joining(" && "));
            if (!nullCheck.isEmpty()) {
                nullCheck = " && " + nullCheck;
            }
            p.format("\n%s@%s\n", indent, imports.add(Override.class));
            p.format("%spublic void postInject(boolean addKeysToContextPath) {\n", indent);
            p.format("%sif (addKeysToContextPath%s) {\n", indent.right(), nullCheck);
            p.format("%scontextPath = contextPath.clearQueries()%s;\n", indent.right(), this.getAddKeys(t, imports));
            p.format("%s}\n", indent.left());
            p.format("%s}\n", indent.left());
            HashSet<String> methodNames = new HashSet<String>();
            this.printPropertyGetterAndSetters(t, imports, indent, p, simpleClassName, t.getFullType(), t.getProperties(), true, methodNames);
            this.addInheritedPropertyNames(t, methodNames);
            this.printNavigationPropertyGetters(t, imports, indent, p, t.getNavigationProperties(), methodNames);
            Generator.addUnmappedFieldsSetterAndGetter(imports, indent, p, methodNames);
            if (t.hasStream()) {
                p.format("\n%s/**\n", indent);
                p.format("%s * If suitable metadata found a StreamProvider is returned otherwise returns\n", indent);
                p.format("%s * {@code Optional.empty()}. Normally for a stream to be available this entity\n", indent);
                p.format("%s * needs to have been hydrated with full metadata. Consider calling the builder\n", indent);
                p.format("%s * method {@code .metadataFull()} when getting this instance (either directly or\n", indent);
                p.format("%s * as part of a collection).\n", indent);
                p.format("%s *\n", indent);
                p.format("%s * @return StreamProvider if suitable metadata found otherwise returns\n", indent);
                p.format("%s *         {@code Optional.empty()}\n", indent);
                p.format("%s */\n", indent);
                p.format("%s@%s\n", indent, imports.add(JsonIgnore.class));
                p.format("%spublic %s<%s> getStream() {\n", indent, imports.add(Optional.class), imports.add(StreamProvider.class));
                p.format("%sreturn %s.createStream(contextPath, this);\n", indent.right(), imports.add(RequestHelper.class));
                p.format("%s}\n", indent.left());
            }
            this.writePatchAndPutMethods(t, simpleClassName, imports, indent, p);
            this.writeCopyMethod(t, simpleClassName, imports, indent, p, true);
            this.writeBoundActionMethods(t, typeActions, imports, indent, p, methodNames);
            this.writeBoundFunctionMethods(t, typeFunctions, imports, indent, p, methodNames);
            this.writeToString(t, simpleClassName, imports, indent, p);
            p.format("%s}\n", indent.left());
            this.writeToFile(imports, w, t.getClassFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void printJsonIncludesNonNull(Indent indent, Imports imports, PrintWriter p) {
        p.format("%s@%s(%s.NON_NULL)\n", indent, imports.add(JsonInclude.class), imports.add(JsonInclude.Include.class));
    }

    private void addInheritedPropertyNames(EntityType t, Set<String> methodNames) {
        while (t.hasBaseType()) {
            EntityType et = this.names.getEntityType(t.getBaseType());
            et.getProperties().forEach(p -> {
                methodNames.add(Names.getGetterMethod(p.getName()));
                methodNames.add(Names.getWithMethod(p.getName()));
                if (this.isStream((TProperty)p)) {
                    for (HttpMethod method : HttpMethod.createOrUpdateMethods()) {
                        methodNames.add(Names.getPutChunkedMethod(p.getName(), method));
                        methodNames.add(Names.getPutMethod(p.getName(), method));
                    }
                }
            });
            t = et;
        }
    }

    private void writeBoundActionMethods(EntityType t, Map<String, List<Action>> typeActions, Imports imports, Indent indent, PrintWriter p, Set<String> methodNames) {
        typeActions.getOrDefault(t.getFullType(), Collections.emptyList()).forEach(action -> this.writeAction(imports, indent, p, (Action)action, methodNames));
    }

    private void writeAction(Imports imports, Indent indent, PrintWriter p, Action action, Set<String> methodNames) {
        p.format("\n%s@%s(name = \"%s\")\n", indent, imports.add(com.github.davidmoten.odata.client.annotation.Action.class), action.getName());
        p.format("%s@%s\n", indent, imports.add(JsonIgnore.class));
        List<Action.Parameter> parameters = action.getParametersUnbound(imports);
        String paramsDeclaration = parameters.stream().map(x -> String.format("%s %s", x.importedFullClassName, x.nameJava())).collect(Collectors.joining(", "));
        String methodName = Generator.disambiguateMethodName(action.getActionMethodName(), methodNames, "_Action");
        if (action.hasReturnType()) {
            boolean isNonCollectionEdm;
            Action.ReturnType returnType = action.getReturnType(imports);
            boolean bl = isNonCollectionEdm = !returnType.isCollection && returnType.innerType.startsWith("Edm.");
            String typ = returnType.isStream() ? imports.add(FunctionRequestReturningStream.class) : (returnType.isCollection ? imports.add(CollectionPageNonEntityRequest.class) : (isNonCollectionEdm ? imports.add(ActionRequestReturningNonCollection.class) : imports.add(ActionRequestReturningNonCollectionUnwrapped.class))) + "<" + action.getReturnType((Imports)imports).innerImportedFullClassName + ">";
            p.format("%spublic %s %s(%s) {\n", indent, typ, methodName, paramsDeclaration);
            Generator.writeActionParameterMapAndNullChecksAndAsciiChecks(imports, indent, p, parameters);
            if (returnType.isCollection) {
                p.format("%sreturn %s.forAction(this.contextPath.addActionOrFunctionSegment(\"%s\"), %s.class, _parameters);\n", indent, imports.add(CollectionPageNonEntityRequest.class), action.getFullType(), returnType.innerImportedFullClassName);
            } else if (returnType.isStream()) {
                p.format("%sthrow new %s(\"Actions that return a stream are not supported yet. If you want this raise an issue at the project home\");\n", indent, imports.add(UnsupportedOperationException.class), action.getFullType());
            } else {
                p.format("%sreturn new %s<%s>(this.contextPath.addActionOrFunctionSegment(\"%s\"), %s.class, _parameters);\n", indent, isNonCollectionEdm ? imports.add(ActionRequestReturningNonCollection.class) : imports.add(ActionRequestReturningNonCollectionUnwrapped.class), returnType.innerImportedFullClassName, action.getFullType(), returnType.innerImportedFullClassName);
            }
        } else {
            p.format("%spublic %s %s(%s) {\n", indent, imports.add(ActionRequestNoReturn.class), methodName, paramsDeclaration);
            Generator.writeActionParameterMapAndNullChecksAndAsciiChecks(imports, indent, p, parameters);
            p.format("%sreturn new %s(this.contextPath.addActionOrFunctionSegment(\"%s\"), _parameters);\n", indent, imports.add(ActionRequestNoReturn.class), action.getFullType());
        }
        p.format("%s}\n", indent.left());
    }

    private static String disambiguateMethodName(String methodName, Set<String> methodNames, String suffix) {
        if (methodNames.contains(methodName)) {
            methodName = methodName + suffix;
        }
        while (methodNames.contains(methodName)) {
            methodName = methodName + "_";
        }
        methodNames.add(methodName);
        return methodName;
    }

    private void writeBoundFunctionMethods(EntityType t, Map<String, List<Function>> typeFunctions, Imports imports, Indent indent, PrintWriter p, Set<String> propertyMethodNames) {
        typeFunctions.getOrDefault(t.getFullType(), Collections.emptyList()).forEach(function -> this.writeFunction(imports, indent, p, (Function)function, propertyMethodNames));
    }

    private void writeFunction(Imports imports, Indent indent, PrintWriter p, Function function, Set<String> methodNames) {
        p.format("\n%s@%s(name = \"%s\")\n", indent, imports.add(com.github.davidmoten.odata.client.annotation.Function.class), function.getName());
        p.format("%s@%s\n", indent, imports.add(JsonIgnore.class));
        List<Function.Parameter> parameters = function.getParametersUnbound(imports);
        String paramsDeclaration = parameters.stream().map(x -> String.format("%s %s", x.importedFullClassName, x.nameJava())).collect(Collectors.joining(", "));
        Function.ReturnType returnType = function.getReturnType(imports);
        boolean isNonCollectionEdm = !returnType.isCollection && returnType.innerType.startsWith("Edm.");
        String methodName = Generator.disambiguateMethodName(function.getActionMethodName(), methodNames, "_Function");
        String typ = returnType.isStream() ? imports.add(FunctionRequestReturningStream.class) : (returnType.isCollection ? imports.add(CollectionPageNonEntityRequest.class) : (isNonCollectionEdm ? imports.add(FunctionRequestReturningNonCollection.class) : imports.add(FunctionRequestReturningNonCollectionUnwrapped.class))) + "<" + function.getReturnType((Imports)imports).innerImportedFullClassName + ">";
        p.format("%spublic %s %s(%s) {\n", indent, typ, methodName, paramsDeclaration);
        Generator.writeFunctionParameterMapAndNullChecksAndAsciiCheck(imports, indent, p, parameters);
        if (returnType.isCollection) {
            p.format("%sreturn %s.forFunction(this.contextPath.addActionOrFunctionSegment(\"%s\"), %s.class, _parameters);\n", indent, imports.add(CollectionPageNonEntityRequest.class), function.getFullType(), returnType.innerImportedFullClassName);
        } else if (returnType.isStream()) {
            p.format("%sreturn new %s(this.contextPath.addActionOrFunctionSegment(\"%s\"), _parameters);\n", indent, imports.add(FunctionRequestReturningStream.class), function.getFullType());
        } else {
            p.format("%sreturn new %s<%s>(this.contextPath.addActionOrFunctionSegment(\"%s\"), %s.class, _parameters);\n", indent, isNonCollectionEdm ? imports.add(FunctionRequestReturningNonCollection.class) : imports.add(FunctionRequestReturningNonCollectionUnwrapped.class), returnType.innerImportedFullClassName, function.getFullType(), returnType.innerImportedFullClassName);
        }
        p.format("%s}\n", indent.left());
    }

    private static void writeActionParameterMapAndNullChecksAndAsciiChecks(Imports imports, Indent indent, PrintWriter p, List<Action.Parameter> parameters) {
        indent.right();
        Generator.writeParameterNullChecks(imports, indent, p, parameters);
        p.format("%s%s<%s, %s> _parameters = %s%s;\n", indent, imports.add(Map.class), imports.add(String.class), imports.add(TypedObject.class), imports.add(ParameterMap.class), parameters.isEmpty() ? ".empty()" : parameters.stream().map(par -> Generator.formatParameterPut(imports, indent, par)).collect(Collectors.joining()) + "\n" + indent.copy().right() + ".build()");
    }

    private static String formatParameterPut(Imports imports, Indent indent, Action.Parameter par) {
        String expression = par.isAscii() ? String.format("%s.checkIsAscii(%s)", imports.add(Checks.class), par.nameJava()) : par.nameJava();
        return String.format("\n%s.put(\"%s\", \"%s\", %s)", indent.copy().right(), par.name, par.typeWithNamespace, expression);
    }

    private static String formatParameterPut(Imports imports, Indent indent, Function.Parameter par) {
        String expression = par.isAscii() ? String.format("%s.checkIsAscii(%s)", imports.add(Checks.class), par.nameJava()) : par.nameJava();
        return String.format("\n%s.put(\"%s\", \"%s\", %s)", indent.copy().right(), par.name, par.typeWithNamespace, expression);
    }

    private static void writeParameterNullChecks(Imports imports, Indent indent, PrintWriter p, List<? extends HasNameJavaHasNullable> parameters) {
        parameters.stream().filter(x -> !x.isNullable()).forEach(x -> p.format("%s%s.checkNotNull(%s, \"%s cannot be null\");\n", indent, imports.add(Preconditions.class), x.nameJava(), x.nameJava()));
    }

    private static void writeFunctionParameterMapAndNullChecksAndAsciiCheck(Imports imports, Indent indent, PrintWriter p, List<Function.Parameter> parameters) {
        indent.right();
        Generator.writeParameterNullChecks(imports, indent, p, parameters);
        p.format("%s%s<%s, %s> _parameters = %s%s;\n", indent, imports.add(Map.class), imports.add(String.class), imports.add(TypedObject.class), imports.add(ParameterMap.class), parameters.isEmpty() ? ".empty()" : parameters.stream().map(par -> Generator.formatParameterPut(imports, indent, par)).collect(Collectors.joining()) + "\n" + indent.copy().right() + ".build()");
    }

    private void writeToString(Structure<?> t, String simpleClassName, Imports imports, Indent indent, PrintWriter p) {
        p.format("\n%s@%s\n", indent, imports.add(Override.class));
        p.format("%spublic %s toString() {\n", indent, imports.add(String.class));
        p.format("%s%s b = new %s();\n", indent.right(), imports.add(StringBuilder.class), imports.add(StringBuilder.class));
        p.format("%sb.append(\"%s[\");\n", indent, simpleClassName);
        boolean[] first = new boolean[]{true};
        t.getFieldNames().forEach(f -> {
            if (first[0]) {
                first[0] = false;
            } else {
                p.format("%sb.append(\", \");\n", indent);
            }
            p.format("%sb.append(\"%s=\");\n", indent, f.name);
            p.format("%sb.append(this.%s);\n", indent, f.fieldName);
        });
        p.format("%sb.append(\"]\");\n", indent);
        p.format("%sb.append(\",unmappedFields=\");\n", indent);
        p.format("%sb.append(unmappedFields);\n", indent);
        p.format("%sb.append(\",odataType=\");\n", indent);
        p.format("%sb.append(odataType);\n", indent);
        p.format("%sreturn b.toString();\n", indent);
        p.format("%s}\n", indent.left());
    }

    private void writeCopyMethod(Structure<?> t, String simpleClassName, Imports imports, Indent indent, PrintWriter p, boolean ofEntity) {
        List<Structure.FieldName> fields = t.getFieldNames();
        p.format("\n%sprivate %s _copy() {\n", indent, simpleClassName);
        p.format("%s%s _x = new %s();\n", indent.right(), simpleClassName, simpleClassName);
        p.format("%s_x.contextPath = contextPath;\n", indent);
        if (ofEntity) {
            p.format("%s_x.changedFields = changedFields;\n", indent);
        }
        p.format("%s_x.unmappedFields = unmappedFields.copy();\n", indent);
        p.format("%s_x.odataType = odataType;\n", indent);
        fields.stream().map(f -> String.format("%s_x.%s = %s;\n", indent, f.fieldName, f.fieldName)).forEach(p::print);
        p.format("%sreturn _x;\n", indent);
        p.format("%s}\n", indent.left());
    }

    private void writeNoArgsConstructor(String simpleClassName, Indent indent, PrintWriter p, boolean hasBaseType) {
        p.format("\n%sprotected %s() {\n", indent, simpleClassName);
        indent.right();
        if (hasBaseType) {
            p.format("%ssuper();\n", indent);
        }
        p.format("%s}\n", indent.left());
    }

    private void writePatchAndPutMethods(EntityType t, String simpleClassName, Imports imports, Indent indent, PrintWriter p) {
        this.writePutOrPatchMethod(t, simpleClassName, imports, indent, p, true);
        this.writePutOrPatchMethod(t, simpleClassName, imports, indent, p, false);
    }

    private void writePutOrPatchMethod(EntityType t, String simpleClassName, Imports imports, Indent indent, PrintWriter p, boolean isPatch) {
        String methodName;
        String string = methodName = isPatch ? "patch" : "put";
        if (isPatch) {
            p.format("\n%s/**", indent);
            p.format("\n%s * Submits only changed fields for update and returns an ", indent);
            p.format("\n%s * immutable copy of {@code this} with changed fields reset.", indent);
            p.format("\n%s *", indent);
            p.format("\n%s * @return a copy of {@code this} with changed fields reset", indent);
            p.format("\n%s * @throws %s if HTTP response is not as expected", indent, imports.add(ClientException.class));
            p.format("\n%s */", indent);
        } else {
            p.format("\n%s/**", indent);
            p.format("\n%s * Submits all fields for update and returns an immutable copy of {@code this}", indent);
            p.format("\n%s * with changed fields reset (they were ignored anyway).", indent);
            p.format("\n%s *", indent);
            p.format("\n%s * @return a copy of {@code this} with changed fields reset", indent);
            p.format("\n%s * @throws %s if HTTP response is not as expected", indent, imports.add(ClientException.class));
            p.format("\n%s */", indent);
        }
        p.format("\n%spublic %s %s() {\n", indent, simpleClassName, methodName);
        p.format("%s%s.%s(this, contextPath, %s.EMPTY);\n", indent.right(), imports.add(RequestHelper.class), methodName, imports.add(RequestOptions.class));
        p.format("%s%s _x = _copy();\n", indent, simpleClassName);
        p.format("%s_x.changedFields = null;\n", indent);
        p.format("%sreturn _x;\n", indent);
        p.format("%s}\n", indent.left());
    }

    private static void addChangedFieldsField(Imports imports, Indent indent, PrintWriter p) {
        p.format("\n%s@%s\n", indent, imports.add(JacksonInject.class));
        p.format("%s@%s\n", indent, imports.add(JsonIgnore.class));
        p.format("%sprotected %s changedFields;\n", indent, imports.add(ChangedFields.class));
    }

    private void writeToFile(Imports imports, StringWriter w, File classFile) throws IOException {
        byte[] bytes = w.toString().replace("IMPORTSHERE", imports.toString()).getBytes(StandardCharsets.UTF_8);
        Files.write(classFile.toPath(), bytes, new OpenOption[0]);
    }

    private void writeComplexType(Schema schema, TComplexType complexType) {
        ComplexType t = new ComplexType(complexType, this.names);
        t.getDirectoryComplexType().mkdirs();
        String simpleClassName = t.getSimpleClassName();
        Imports imports = new Imports(t.getFullClassName());
        Indent indent = new Indent();
        StringWriter w = new StringWriter();
        try (PrintWriter p = new PrintWriter(w);){
            p.format("package %s;\n\n", t.getPackage());
            p.format("IMPORTSHERE", new Object[0]);
            t.printJavadoc(p, indent);
            this.printPropertyOrder(imports, p, t.getProperties());
            Generator.printJsonIncludesNonNull(indent, imports, p);
            p.format("public class %s%s implements %s {\n", simpleClassName, t.getExtendsClause(imports), imports.add(ODataType.class));
            indent.right();
            if (!t.hasBaseType()) {
                Generator.addContextPathInjectableField(imports, indent, p);
            }
            if (!t.hasBaseType()) {
                Generator.addUnmappedFieldsField(imports, indent, p);
            }
            this.printPropertyFields(imports, indent, p, t.getProperties(), t.hasBaseType());
            this.writeNoArgsConstructor(simpleClassName, indent, p, t.hasBaseType());
            p.format("\n%s@%s\n", indent, imports.add(Override.class));
            p.format("%spublic String odataTypeName() {\n", indent);
            p.format("%sreturn \"%s\";\n", indent.right(), t.getFullType());
            p.format("%s}\n", indent.left());
            HashSet<String> methodNames = new HashSet<String>();
            this.printPropertyGetterAndSetters(t, imports, indent, p, simpleClassName, t.getFullType(), t.getProperties(), false, methodNames);
            Generator.addUnmappedFieldsSetterAndGetter(imports, indent, p, methodNames);
            p.format("\n%s@%s\n", indent, imports.add(Override.class));
            p.format("%spublic void postInject(boolean addKeysToContextPath) {\n", indent);
            p.format("%s// do nothing;\n", indent.right());
            p.format("%s}\n", indent.left());
            this.writeBuilder(t, simpleClassName, imports, indent, p);
            this.writeCopyMethod(t, simpleClassName, imports, indent, p, false);
            this.writeToString(t, simpleClassName, imports, indent, p);
            p.format("\n}\n", new Object[0]);
            this.writeToFile(imports, w, t.getClassFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeEntityRequest(Schema schema, TEntityType entityType, Map<String, List<Action>> typeActions, Map<String, List<Function>> typeFunctions) {
        EntityType t = new EntityType(entityType, this.names);
        this.names.getDirectoryEntityRequest(schema).mkdirs();
        String simpleClassName = t.getSimpleClassNameEntityRequest();
        Imports imports = new Imports(t.getFullClassNameEntityRequest());
        Indent indent = new Indent();
        StringWriter w = new StringWriter();
        try (PrintWriter p = new PrintWriter(w);){
            p.format("package %s;\n\n", t.getPackageEntityRequest());
            p.format("IMPORTSHERE", new Object[0]);
            p.format("@%s\n", imports.add(JsonIgnoreType.class));
            p.format("public class %s extends %s {\n\n", simpleClassName, imports.add(EntityRequest.class) + "<" + imports.add(t.getFullClassNameEntity()) + ">");
            indent.right();
            p.format("%spublic %s(%s contextPath, %s<%s> value) {\n", indent, simpleClassName, imports.add(ContextPath.class), imports.add(Optional.class), imports.add(Object.class));
            p.format("%ssuper(%s.class, contextPath, value);\n", indent.right(), imports.add(t.getFullClassNameEntity()));
            p.format("%s}\n", indent.left());
            indent.left();
            if (t.hasStream()) {
                p.format("\n%s/**\n", indent);
                p.format("%s * If returning a stream without using object metadata is not supported then", indent);
                p.format("%s * returns {@code Optional.empty()}. Otherwise, returns a stream provider\n", indent);
                p.format("%s * where the location of the stream is assumed to be the current path + {@code /$value}.\n", indent);
                p.format("%s *\n", indent);
                p.format("%s * @return StreamProvider if suitable metadata found otherwise returns\n", indent);
                p.format("%s *         {@code Optional.empty()}\n", indent);
                p.format("%s */\n", indent);
                p.format("%s@%s\n", indent, imports.add(JsonIgnore.class));
                p.format("%spublic %s<%s> getStreamCurrentPath() {\n", indent, imports.add(Optional.class), imports.add(StreamProvider.class));
                p.format("%sreturn %s.createStream(contextPath, null);\n", indent.right(), imports.add(RequestHelper.class));
                p.format("%s}\n", indent.left());
            }
            t.getNavigationProperties().stream().filter(x -> {
                boolean isEntity = this.names.isEntityWithNamespace(this.names.getInnerType(this.names.getType((TNavigationProperty)x)));
                if (!isEntity) {
                    this.log("Unexpected entity with non-entity navigation property type: " + simpleClassName + "." + x.getName() + ". If you get this message then raise an issue on the github project for odata-client.");
                }
                return isEntity;
            }).forEach(x -> {
                String inner;
                indent.right();
                String y = x.getType().get(0);
                Schema sch = this.names.getSchema(this.names.getInnerType(y));
                String returnClass = Names.isCollection(y) ? this.toClassName((TNavigationProperty)x, imports) : imports.add(this.names.getFullClassNameEntityRequestFromTypeWithNamespace(sch, y));
                p.format("\n%spublic %s %s() {\n", indent, returnClass, Names.getGetterMethodWithoutGet(x.getName()));
                if (this.isCollection((TNavigationProperty)x)) {
                    p.format("%sreturn new %s(\n", indent.right(), this.toClassName((TNavigationProperty)x, imports));
                    p.format("%scontextPath.addSegment(\"%s\"), %s.empty());\n", indent.right().right().right().right(), x.getName(), imports.add(Optional.class));
                    indent.left().left().left().left();
                } else {
                    p.format("%sreturn new %s(contextPath.addSegment(\"%s\"), %s.empty());\n", indent.right(), returnClass, x.getName(), imports.add(Optional.class));
                }
                p.format("%s}\n", indent.left());
                if (y.startsWith(COLLECTION_PREFIX) && this.names.isEntityWithNamespace(inner = this.names.getInnerType(y))) {
                    String entityRequestType = this.names.getFullClassNameEntityRequestFromTypeWithNamespace(sch, inner);
                    EntityType et = this.names.getEntityType(inner);
                    KeyInfo k = this.getKeyInfo(et, imports);
                    p.format("\n%spublic %s %s(%s) {\n", indent, imports.add(entityRequestType), Names.getIdentifier(x.getName()), k.typedParams);
                    p.format("%sreturn new %s(contextPath.addSegment(\"%s\")%s, %s.empty());\n", indent.right(), imports.add(entityRequestType), x.getName(), k.addKeys, imports.add(Optional.class));
                    p.format("%s}\n", indent.left());
                }
                indent.left();
            });
            indent.right();
            HashSet<String> methodNames = new HashSet<String>();
            this.writeBoundActionMethods(t, typeActions, imports, indent, p, methodNames);
            this.writeBoundFunctionMethods(t, typeFunctions, imports, indent, p, methodNames);
            indent.left();
            p.format("\n}\n", new Object[0]);
            this.writeToFile(imports, w, t.getClassFileEntityRequest());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<String> fieldNames(EntityType et) {
        if (et.isAbstract() && et.getKeys().isEmpty()) {
            return Collections.emptyList();
        }
        return Generator.fieldNames(et.getFirstKey());
    }

    private static List<String> fieldNames(KeyElement key) {
        return key.getPropertyRefs().stream().map(z -> z.getReferredProperty().getFieldName()).collect(Collectors.toList());
    }

    private KeyInfo getKeyInfo(EntityType et, Imports imports) {
        KeyElement key = et.getFirstKey();
        String typedParams = key.getPropertyRefs().stream().map(PropertyRef::getReferredProperty).map(z -> String.format("%s %s", z.getImportedType(imports), z.getFieldName())).collect(Collectors.joining(", "));
        String addKeys = this.getAddKeys(et, imports, key);
        return new KeyInfo(typedParams, addKeys);
    }

    private String getAddKeys(EntityType et, Imports imports) {
        if (et.isAbstract() && et.getKeys().isEmpty()) {
            return "";
        }
        KeyElement key = et.getFirstKey();
        return this.getAddKeys(et, imports, key);
    }

    private String getAddKeys(EntityType et, Imports imports, KeyElement key) {
        String addKeys = et.getFirstKey().getPropertyRefs().stream().map(PropertyRef::getReferredProperty).map(z -> {
            if (key.getPropertyRefs().size() > 1) {
                return String.format("new %s(\"%s\", %s)", imports.add(NameValue.class), z.getName(), z.getFieldName());
            }
            return String.format("new %s(%s.toString())", imports.add(NameValue.class), z.getFieldName());
        }).collect(Collectors.joining(", "));
        return ".addKeys(" + addKeys + ")";
    }

    private void writeContainer(Schema schema, TEntityContainer t) {
        this.names.getDirectoryContainer(schema).mkdirs();
        String simpleClassName = this.names.getSimpleClassNameContainer(schema, t.getName());
        Imports imports = new Imports(this.names.getFullClassNameContainer(schema, t.getName()));
        Indent indent = new Indent();
        StringWriter w = new StringWriter();
        try (PrintWriter p = new PrintWriter(w);){
            p.format("package %s;\n\n", this.names.getPackageContainer(schema));
            p.format("IMPORTSHERE", new Object[0]);
            String extension = t.getExtends() != null ? " extends " + imports.add(this.names.getFullClassNameFromTypeWithNamespace(t.getExtends())) : "";
            p.format("public final class %s%s implements %s {\n\n", simpleClassName, extension, imports.add(HasContext.class));
            p.format("%sprivate final %s contextPath;\n\n", indent.right(), imports.add(ContextPath.class));
            p.format("%spublic %s(%s context) {\n", indent, simpleClassName, imports.add(Context.class));
            p.format("%sthis.contextPath = new %s(context, context.service().getBasePath());\n", indent.right(), imports.add(ContextPath.class));
            p.format("%s}\n", indent.left());
            p.format("\n%s@%s\n", indent, imports.add(Override.class));
            p.format("%spublic %s _context() {\n", indent, imports.add(Context.class));
            p.format("%sreturn contextPath.context();\n", indent.right());
            p.format("%s}\n", indent.left());
            p.format("\n%spublic %s _service() {\n", indent, imports.add(HttpService.class));
            p.format("%sreturn contextPath.context().service();\n", indent.right());
            p.format("%s}\n", indent.left());
            p.format("\n%sstatic final class ContainerBuilderImpl extends %s<%s> {\n", indent, imports.add(TestingService.ContainerBuilder.class), simpleClassName);
            p.format("\n%s@%s\n", indent.right(), imports.add(Override.class));
            p.format("%spublic %s _create(%s context) {\n", indent, simpleClassName, imports.add(Context.class));
            p.format("%sreturn new %s(context);\n", indent.right(), simpleClassName);
            p.format("%s}\n", indent.left());
            p.format("%s}\n", indent.left());
            p.format("\n%spublic static %s<%s<%s>, %s> test() {\n", indent, imports.add(TestingService.BuilderBase.class), imports.add(TestingService.ContainerBuilder.class), simpleClassName, simpleClassName);
            p.format("%sreturn new ContainerBuilderImpl();\n", indent.right());
            p.format("%s}\n", indent.left());
            com.github.davidmoten.odata.client.generator.Util.filter(t.getEntitySetOrActionImportOrFunctionImport(), TEntitySet.class).forEach(x -> {
                EntitySet es = new EntitySet(schema, t, (TEntitySet)x, this.names);
                Schema sch = this.names.getSchema(x.getEntityType());
                p.format("\n%spublic %s %s() {\n", indent, imports.add(es.getFullClassNameEntitySet()), Names.getIdentifier(x.getName()));
                p.format("%sreturn new %s(\n", indent.right(), imports.add(es.getFullClassNameEntitySet()));
                p.format("%scontextPath.addSegment(\"%s\"));\n", indent.right().right().right().right(), x.getName());
                p.format("%s}\n", indent.left().left().left().left().left());
                if (this.names.isEntityWithNamespace(x.getEntityType())) {
                    String entityRequestType = this.names.getFullClassNameEntityRequestFromTypeWithNamespace(sch, x.getEntityType());
                    EntityType et = this.names.getEntityType(x.getEntityType());
                    KeyInfo k = this.getKeyInfo(et, imports);
                    p.format("\n%spublic %s %s(%s) {\n", indent, imports.add(entityRequestType), Names.getIdentifier(x.getName()), k.typedParams);
                    p.format("%sreturn new %s(contextPath.addSegment(\"%s\")%s, %s.empty());\n", indent.right(), imports.add(entityRequestType), x.getName(), k.addKeys, imports.add(Optional.class));
                    p.format("%s}\n", indent.left());
                }
            });
            com.github.davidmoten.odata.client.generator.Util.filter(t.getEntitySetOrActionImportOrFunctionImport(), TSingleton.class).forEach(x -> {
                String importedType = this.toClassName((TSingleton)x, imports);
                p.format("\n%spublic %s %s() {\n", indent, importedType, Names.getIdentifier(x.getName()));
                p.format("%sreturn new %s(contextPath.addSegment(\"%s\"), %s.empty());\n", indent.right(), importedType, x.getName(), imports.add(Optional.class));
                p.format("%s}\n", indent.left());
            });
            HashSet methodNames = new HashSet();
            com.github.davidmoten.odata.client.generator.Util.types(schema, TAction.class).filter(x -> !x.isIsBound()).forEach(x -> this.writeAction(imports, indent, p, new Action((TAction)x, this.names), methodNames));
            com.github.davidmoten.odata.client.generator.Util.types(schema, TFunction.class).filter(x -> !x.isIsBound()).forEach(x -> this.writeFunction(imports, indent, p, new Function((TFunction)x, this.names), methodNames));
            p.format("\n}\n", new Object[0]);
            File classFile = this.names.getClassFileContainer(schema, t.getName());
            this.writeToFile(imports, w, classFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeEntityCollectionRequest(Schema schema, TEntityType entityType, Map<String, List<Action>> collectionTypeActions, Map<String, List<Function>> collectionTypeFunctions, Set<String> collectionTypes) {
        EntityType t = new EntityType(entityType, this.names);
        if (!collectionTypes.contains(t.getFullType())) {
            return;
        }
        this.names.getDirectoryEntityCollectionRequest(schema).mkdirs();
        String simpleClassName = this.names.getSimpleClassNameCollectionRequest(schema, t.getName());
        Imports imports = new Imports(this.names.getFullClassNameCollectionRequest(schema, t.getName()));
        Indent indent = new Indent();
        StringWriter w = new StringWriter();
        try (PrintWriter p = new PrintWriter(w);){
            p.format("package %s;\n\n", this.names.getPackageCollectionRequest(schema));
            p.format("IMPORTSHERE", new Object[0]);
            p.format("public class %s extends %s<%s, %s>{\n\n", simpleClassName, imports.add(CollectionPageEntityRequest.class), imports.add(this.names.getFullClassNameFromTypeWithoutNamespace(schema, t.getName())), imports.add(this.names.getFullClassNameEntityRequest(schema, t.getName())));
            indent.right();
            Generator.addContextPathField(imports, indent, p);
            p.format("\n%spublic %s(%s contextPath, %s<%s> value) {\n", indent, simpleClassName, imports.add(ContextPath.class), imports.add(Optional.class), imports.add(Object.class));
            p.format("%ssuper(contextPath, %s.class, cp -> new %s(cp, Optional.empty()), value);\n", indent.right(), imports.add(this.names.getFullClassNameFromTypeWithoutNamespace(schema, t.getName())), imports.add(this.names.getFullClassNameEntityRequestFromTypeWithoutNamespace(schema, t.getName())));
            p.format("%sthis.contextPath = contextPath;\n", indent);
            p.format("%s}\n", indent.left());
            t.getNavigationProperties().forEach(x -> {
                Schema sch = this.names.getSchema(this.names.getInnerType(this.names.getType((TNavigationProperty)x)));
                if (x.getType().get(0).startsWith(COLLECTION_PREFIX)) {
                    String y = this.names.getInnerType(this.names.getType((TNavigationProperty)x));
                    p.format("\n%spublic %s %s() {\n", indent, imports.add(this.names.getFullClassNameCollectionRequestFromTypeWithNamespace(sch, y)), Names.getIdentifier(x.getName()));
                    p.format("%sreturn new %s(contextPath.addSegment(\"%s\"), %s.empty());\n", indent.right(), imports.add(this.names.getFullClassNameCollectionRequestFromTypeWithNamespace(sch, y)), x.getName(), imports.add(Optional.class));
                    p.format("%s}\n", indent.left());
                    if (this.names.isEntityWithNamespace(y)) {
                        String entityRequestType = this.names.getFullClassNameEntityRequestFromTypeWithNamespace(sch, y);
                        EntityType et = this.names.getEntityType(y);
                        KeyInfo k = this.getKeyInfo(et, imports);
                        p.format("\n%spublic %s %s(%s) {\n", indent, imports.add(entityRequestType), Names.getIdentifier(x.getName()), k.typedParams);
                        p.format("%sreturn new %s(contextPath.addSegment(\"%s\")%s, %s.empty());\n", indent.right(), imports.add(entityRequestType), x.getName(), k.addKeys, imports.add(Optional.class));
                        p.format("%s}\n", indent.left());
                    }
                }
            });
            HashSet<String> methodNames = new HashSet<String>();
            this.writeBoundActionMethods(t, collectionTypeActions, imports, indent, p, methodNames);
            this.writeBoundFunctionMethods(t, collectionTypeFunctions, imports, indent, p, methodNames);
            indent.left();
            p.format("\n}\n", new Object[0]);
            this.writeToFile(imports, w, t.getClassFileCollectionRequest());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeBuilder(Structure<?> t, String simpleClassName, Imports imports, Indent indent, PrintWriter p) {
        if (t.isAbstract()) {
            return;
        }
        String builderSuffix = t.getBaseType() == null ? "" : simpleClassName;
        p.format("\n%s/**", indent);
        p.format("\n%s * Returns a builder which is used to create a new", indent);
        p.format("\n%s * instance of this class (given that this class is immutable).", indent);
        p.format("\n%s *", indent);
        p.format("\n%s * @return a new Builder for this class", indent);
        p.format("\n%s */", indent);
        p.format("\n%s// Suffix used on builder factory method to differentiate the method", indent);
        p.format("\n%s// from static builder methods on superclasses", indent);
        p.format("\n%spublic static Builder builder%s() {\n", indent, builderSuffix);
        p.format("%sreturn new Builder();\n", indent.right());
        p.format("%s}\n", indent.left());
        p.format("\n%spublic static final class Builder {\n", indent);
        indent.right();
        List<Field> fields = t.getFields(imports);
        fields.forEach(f -> p.format("%sprivate %s %s;\n", indent, f.importedType, f.fieldName));
        if (!fields.isEmpty()) {
            p.format("%sprivate %s changedFields = new %s();\n", indent, imports.add(ChangedFields.class), imports.add(ChangedFields.class));
        }
        p.format("\n%sBuilder() {\n", indent);
        p.format("%s// prevent instantiation\n", indent.right());
        p.format("%s}\n", indent.left());
        fields.forEach(f -> {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put(f.fieldName, "value of {@code " + f.propertyName + "} property (as defined in service metadata)");
            t.printPropertyJavadoc(p, indent, f.name, "{@code this} (for method chaining)", map);
            p.format("\n%spublic Builder %s(%s %s) {\n", indent, f.fieldName, f.importedType, f.fieldName);
            p.format("%sthis.%s = %s;\n", indent.right(), f.fieldName, f.fieldName);
            p.format("%sthis.changedFields = changedFields.add(\"%s\");\n", indent, f.name);
            p.format("%sreturn this;\n", indent);
            p.format("%s}\n", indent.left());
            if (f.isCollection) {
                t.printPropertyJavadoc(p, indent, f.name, "{@code this} (for method chaining)", map);
                p.format("\n%spublic Builder %s(%s... %s) {\n", indent, f.fieldName, imports.add(f.innerFullClassName), f.fieldName);
                p.format("%sreturn %s(%s.asList(%s));\n", indent.right(), f.fieldName, imports.add(Arrays.class), f.fieldName);
                p.format("%s}\n", indent.left());
            }
        });
        p.format("\n%spublic %s build() {\n", indent, simpleClassName);
        p.format("%s%s _x = new %s();\n", indent.right(), simpleClassName, simpleClassName);
        p.format("%s_x.contextPath = null;\n", indent);
        if (t instanceof EntityType) {
            p.format("%s_x.changedFields = changedFields;\n", indent);
        }
        p.format("%s_x.unmappedFields = new %s();\n", indent, imports.add(UnmappedFieldsImpl.class));
        p.format("%s_x.odataType = \"%s\";\n", indent, t.getFullType());
        fields.stream().map(f -> String.format("%s_x.%s = %s;\n", indent, f.fieldName, f.fieldName)).forEach(p::print);
        p.format("%sreturn _x;\n", indent);
        p.format("%s}\n", indent.left());
        p.format("%s}\n", indent.left());
    }

    private static void addUnmappedFieldsField(Imports imports, Indent indent, PrintWriter p) {
        p.format("\n%s@%s\n", indent, imports.add(JacksonInject.class));
        p.format("%s@%s\n", indent, imports.add(JsonIgnore.class));
        p.format("%sprotected %s unmappedFields;\n", indent, imports.add(UnmappedFieldsImpl.class));
    }

    private static void addUnmappedFieldsSetterAndGetter(Imports imports, Indent indent, PrintWriter p, Set<String> methodNames) {
        p.format("\n%s@%s\n", indent, imports.add(JsonAnySetter.class));
        methodNames.add("setUnmappedField");
        p.format("%sprivate void setUnmappedField(%s name, %s value) {\n", indent, imports.add(String.class), imports.add(Object.class));
        p.format("%sif (unmappedFields == null) {\n", indent.right());
        p.format("%sunmappedFields = new %s();\n", indent.right(), imports.add(UnmappedFieldsImpl.class));
        p.format("%s}\n", indent.left());
        p.format("%sunmappedFields.put(name, value);\n", indent);
        p.format("%s}\n", indent.left());
        methodNames.add("unmappedFields");
        p.format("\n%s@%s\n", indent, imports.add(JsonAnyGetter.class));
        p.format("%sprivate %s unmappedFields() {\n", indent, imports.add(UnmappedFieldsImpl.class));
        p.format("%sreturn unmappedFields == null ? %s.EMPTY : unmappedFields;\n", indent.right(), imports.add(UnmappedFieldsImpl.class));
        p.format("%s}\n", indent.left());
        methodNames.add("getUnmappedFields");
        p.format("\n%s@%s\n", indent, imports.add(Override.class));
        p.format("%spublic %s getUnmappedFields() {\n", indent, imports.add(UnmappedFields.class));
        p.format("%sreturn unmappedFields();\n", indent.right());
        p.format("%s}\n", indent.left());
    }

    private static void addContextPathInjectableField(Imports imports, Indent indent, PrintWriter p) {
        p.format("\n%s@%s\n", indent, imports.add(JacksonInject.class));
        p.format("%s@%s\n", indent, imports.add(JsonIgnore.class));
        Generator.addContextPathField(imports, indent, p);
    }

    private static void addContextPathField(Imports imports, Indent indent, PrintWriter p) {
        p.format("%sprotected %s%s contextPath;\n", indent, "", imports.add(ContextPath.class));
    }

    private void printPropertyGetterAndSetters(Structure<?> structure, Imports imports, Indent indent, PrintWriter p, String simpleClassName, String fullType, List<TProperty> properties, boolean ofEntity, Set<String> methodNames) {
        properties.forEach(x -> {
            String fieldName = Names.getIdentifier(x.getName());
            String t = this.names.getType((TProperty)x);
            boolean isCollection = this.isCollection((TProperty)x);
            structure.printPropertyJavadoc(p, indent, x.getName(), "property " + x.getName(), Collections.emptyMap());
            this.addPropertyAnnotation(imports, indent, p, x.getName());
            p.format("\n%s@%s\n", indent, imports.add(JsonIgnore.class));
            String methodName = Names.getGetterMethod(x.getName());
            methodNames.add(methodName);
            if (isCollection) {
                String inner = this.names.getInnerType(t);
                String importedInnerType = this.names.toImportedTypeNonCollection(inner, imports);
                boolean isEntity = this.names.isEntityWithNamespace(inner);
                String options = String.format("%s.EMPTY", imports.add(HttpRequestOptions.class));
                p.format("%spublic %s<%s> %s() {\n", indent, imports.add(CollectionPage.class), importedInnerType, methodName);
                this.writePropertyGetterCollectionBody(imports, indent, p, fieldName, inner, importedInnerType, isEntity, options);
                p.format("%s}\n", indent.left());
                if (!isEntity && ofEntity) {
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    map.put(fieldName, "new value of {@code " + x.getName() + "} field (as defined in service metadata)");
                    structure.printMutatePropertyJavadoc(p, indent, x.getName(), map);
                    String classSuffix = "";
                    String withMethodName = Names.getWithMethod(x.getName());
                    methodNames.add(withMethodName);
                    p.format("\n%spublic %s%s %s(%s<%s> %s) {\n", indent, simpleClassName, classSuffix, withMethodName, imports.add(List.class), importedInnerType, fieldName);
                    p.format("%s%s _x = _copy();\n", indent.right(), simpleClassName);
                    if (ofEntity) {
                        p.format("%s_x.changedFields = changedFields.add(\"%s\");\n", indent, x.getName());
                    }
                    p.format("%s_x.odataType = %s.nvl(odataType, \"%s\");\n", indent, imports.add(Util.class), fullType);
                    p.format("%s_x.%s = %s;\n", indent, fieldName, fieldName);
                    p.format("%sreturn _x;\n", indent);
                    p.format("%s}\n", indent.left());
                }
                options = "options";
                HashMap<String, String> parameterDoc = new HashMap<String, String>();
                parameterDoc.put("options", "specify connect and read timeouts");
                structure.printPropertyJavadoc(p, indent, x.getName(), "property " + x.getName(), parameterDoc);
                this.addPropertyAnnotation(imports, indent, p, x.getName());
                p.format("\n%s@%s\n", indent, imports.add(JsonIgnore.class));
                p.format("%spublic %s<%s> %s(%s options) {\n", indent, imports.add(CollectionPage.class), importedInnerType, methodName, imports.add(HttpRequestOptions.class));
                this.writePropertyGetterCollectionBody(imports, indent, p, fieldName, inner, importedInnerType, isEntity, options);
                p.format("%s}\n", indent.left());
            } else {
                boolean isStream = this.isStream((TProperty)x);
                if (isStream) {
                    p.format("%spublic %s<%s> %s() {\n", indent, imports.add(Optional.class), imports.add(StreamProvider.class), methodName);
                    p.format("%sreturn %s.createStreamForEdmStream(contextPath, this, \"%s\", %s);\n", indent.right(), imports.add(RequestHelper.class), x.getName(), fieldName);
                    p.format("%s}\n", indent.left());
                    for (HttpMethod method : HttpMethod.createOrUpdateMethods()) {
                        String putMethodName = Names.getPutMethod(x.getName(), method);
                        methodNames.add(putMethodName);
                        p.format("\n%s/**", indent);
                        p.format("\n%s * If metadata indicate that the stream is editable then returns", indent);
                        p.format("\n%s * a {@link StreamUploader} which can be used to upload the stream", indent);
                        p.format("\n%s * to the {@code %s} property, using HTTP %s.", indent, x.getName(), method);
                        p.format("\n%s *", indent);
                        p.format("\n%s * @return a StreamUploader if upload permitted", indent);
                        p.format("\n%s */", indent);
                        this.addPropertyAnnotation(imports, indent, p, x.getName());
                        p.format("\n%spublic %s<%s> %s() {\n", indent, imports.add(Optional.class), imports.add(StreamUploaderSingleCall.class), putMethodName);
                        p.format("%sreturn %s(%s.singleCall());\n", indent.right(), putMethodName, imports.add(UploadStrategy.class));
                        p.format("%s}\n", indent.left());
                        String putChunkedMethodName = Names.getPutChunkedMethod(x.getName(), method);
                        methodNames.add(putChunkedMethodName);
                        p.format("\n%s/**", indent);
                        p.format("\n%s * If metadata indicate that the stream is editable then returns", indent);
                        p.format("\n%s * a {@link StreamUploaderChunked} which can be used to upload the stream", indent);
                        p.format("\n%s * to the {@code %s} property, using HTTP %s.", indent, x.getName(), method);
                        p.format("\n%s *", indent);
                        p.format("\n%s * @return a StreamUploaderChunked if upload permitted", indent);
                        p.format("\n%s */", indent);
                        this.addPropertyAnnotation(imports, indent, p, x.getName());
                        p.format("\n%spublic %s<%s> %s() {\n", indent, imports.add(Optional.class), imports.add(StreamUploaderChunked.class), putChunkedMethodName);
                        p.format("%sreturn %s(%s.chunked());\n", indent.right(), putMethodName, imports.add(UploadStrategy.class));
                        p.format("%s}\n", indent.left());
                        this.addPropertyAnnotation(imports, indent, p, x.getName());
                        p.format("\n%spublic <T extends %s<T>> Optional<T> %s(%s<T> strategy) {\n", indent, imports.add(StreamUploader.class), putMethodName, imports.add(UploadStrategy.class));
                        p.format("%sreturn strategy.builder(contextPath.addSegment(\"%s\"), this, \"%s\", %s.%s);\n", indent.right(), x.getName(), x.getName(), imports.add(HttpMethod.class), method.name());
                        p.format("%s}\n", indent.left());
                    }
                } else {
                    String importedType = this.names.toImportedTypeNonCollection(t, imports);
                    String importedTypeWithOptional = imports.add(Optional.class) + "<" + importedType + ">";
                    p.format("%spublic %s %s() {\n", indent, importedTypeWithOptional, methodName);
                    p.format("%sreturn %s.ofNullable(%s);\n", indent.right(), imports.add(Optional.class), fieldName);
                    p.format("%s}\n", indent.left());
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    map.put(fieldName, "new value of {@code " + x.getName() + "} field (as defined in service metadata)");
                    structure.printMutatePropertyJavadoc(p, indent, x.getName(), map);
                    String classSuffix = "";
                    String withMethodName = Names.getWithMethod(x.getName());
                    methodNames.add(withMethodName);
                    p.format("\n%spublic %s%s %s(%s %s) {\n", indent, simpleClassName, classSuffix, withMethodName, importedType, fieldName);
                    if (x.isUnicode() != null && !x.isUnicode().booleanValue()) {
                        p.format("%s%s.checkIsAscii(%s);\n", indent.right(), imports.add(Checks.class), fieldName);
                        indent.left();
                    }
                    p.format("%s%s _x = _copy();\n", indent.right(), simpleClassName);
                    if (ofEntity) {
                        p.format("%s_x.changedFields = changedFields.add(\"%s\");\n", indent, x.getName());
                    }
                    p.format("%s_x.odataType = %s.nvl(odataType, \"%s\");\n", indent, imports.add(Util.class), fullType);
                    p.format("%s_x.%s = %s;\n", indent, fieldName, fieldName);
                    p.format("%sreturn _x;\n", indent);
                    p.format("%s}\n", indent.left());
                }
                if (structure.getSimpleClassName().equals("UploadSession") && x.getName().equals("uploadUrl")) {
                    this.addPropertyAnnotation(imports, indent, p, x.getName());
                    p.format("\n%spublic <T extends %s<T>> T put(%s<T> strategy) {\n", indent, imports.add(StreamUploader.class), imports.add(UploadStrategy.class));
                    p.format("%sthis.unmappedFields.put(\"uploadUrl@odata.mediaEditLink\", uploadUrl);\n", indent.right());
                    p.format("%sreturn strategy.builder(new %s(contextPath.context(), new %s(uploadUrl, contextPath.context().service().getBasePath().style())), this, \"uploadUrl\", %s.%s).get();\n", indent, imports.add(ContextPath.class), imports.add(Path.class), imports.add(HttpMethod.class), HttpMethod.PUT.name());
                    p.format("%s}\n", indent.left());
                    this.addPropertyAnnotation(imports, indent, p, x.getName());
                    p.format("\n%spublic %s putChunked() {\n", indent, imports.add(StreamUploaderChunked.class));
                    p.format("%sreturn put(%s.chunked());\n", indent.right(), imports.add(UploadStrategy.class));
                    p.format("%s}\n", indent.left());
                    this.addPropertyAnnotation(imports, indent, p, x.getName());
                    p.format("\n%spublic %s put() {\n", indent, imports.add(StreamUploaderSingleCall.class));
                    p.format("%sreturn put(%s.singleCall());\n", indent.right(), imports.add(UploadStrategy.class));
                    p.format("%s}\n", indent.left());
                }
            }
        });
        String method = Names.getWithMethod("unmappedField");
        p.format("\n%spublic %s %s(%s name, %s value) {\n", indent, simpleClassName, method, imports.add(String.class), imports.add(String.class));
        p.format("%s%s _x = _copy();\n", indent.right(), simpleClassName);
        p.format("%s_x.setUnmappedField(name, value);\n", indent);
        p.format("%sreturn _x;\n", indent);
        p.format("%s}\n", indent.left());
    }

    private void writePropertyGetterCollectionBody(Imports imports, Indent indent, PrintWriter p, String fieldName, String inner, String importedInnerType, boolean isEntity, String options) {
        if (isEntity) {
            p.format("%sreturn %s.from(contextPath.context(), %s, %s.class, %s.emptyList());\n", indent.right(), imports.add(CollectionPage.class), fieldName, importedInnerType, imports.add(Collections.class));
        } else {
            p.format("%sreturn new %s<%s>(contextPath, %s.class, this.%s, %s.ofNullable(%sNextLink), %s.emptyList(), %s);\n", indent.right(), imports.add(CollectionPage.class), importedInnerType, importedInnerType, fieldName, imports.add(Optional.class), fieldName, imports.add(Collections.class), options);
        }
    }

    private boolean isStream(TProperty x) {
        return "Edm.Stream".equals(this.names.getType(x));
    }

    private void addPropertyAnnotation(Imports imports, Indent indent, PrintWriter p, String name) {
        p.format("\n%s@%s(name=\"%s\")", indent, imports.add(Property.class), name);
    }

    private void addNavigationPropertyAnnotation(Imports imports, Indent indent, PrintWriter p, String name) {
        p.format("\n%s@%s(name=\"%s\")\n", indent, imports.add(NavigationProperty.class), name);
    }

    private void printPropertyOrder(Imports imports, PrintWriter p, List<TProperty> properties) {
        String props = Stream.concat(Stream.of("@odata.type"), properties.stream().map(TProperty::getName)).map(x -> "\n    \"" + x + "\"").collect(Collectors.joining(", "));
        p.format("@%s({%s})\n", imports.add(JsonPropertyOrder.class), props);
    }

    private void printPropertyFields(Imports imports, Indent indent, PrintWriter p, List<TProperty> properties, boolean hasBaseType) {
        if (!hasBaseType) {
            p.format("\n%s@%s(\"%s\")\n", indent, imports.add(JsonProperty.class), "@odata.type");
            p.format("%sprotected %s %s;\n", indent, imports.add(String.class), "odataType");
        }
        properties.forEach(x -> {
            p.format("\n%s@%s(\"%s\")\n", indent, imports.add(JsonProperty.class), x.getName());
            p.format("%sprotected %s %s;\n", indent, this.names.toImportedFullClassName((TProperty)x, imports), Names.getIdentifier(x.getName()));
            String t = this.names.getInnerType(this.names.getType((TProperty)x));
            if (this.isCollection((TProperty)x) && !this.names.isEntityWithNamespace(t)) {
                p.format("\n%s@%s(\"%s@nextLink\")\n", indent, imports.add(JsonProperty.class), x.getName());
                p.format("%sprotected %s %sNextLink;\n", indent, imports.add(String.class), Names.getIdentifier(x.getName()));
            }
        });
    }

    private void printNavigationPropertyGetters(Structure<?> structure, Imports imports, Indent indent, PrintWriter p, List<TNavigationProperty> properties, Set<String> methodNames) {
        properties.forEach(x -> {
            String typeName = this.toClassName((TNavigationProperty)x, imports);
            String methodName = Names.getGetterMethod(x.getName());
            methodNames.add(methodName);
            structure.printPropertyJavadoc(p, indent, x.getName(), "navigational property " + x.getName(), Collections.emptyMap());
            this.addNavigationPropertyAnnotation(imports, indent, p, x.getName());
            p.format("%s@%s\n", indent, imports.add(JsonIgnore.class));
            p.format("%spublic %s %s() {\n", indent, typeName, methodName);
            if (this.isCollection((TNavigationProperty)x)) {
                if (!this.names.isEntityWithNamespace(this.names.getType((TNavigationProperty)x))) throw new RuntimeException("unexpected");
                p.format("%sreturn new %s(\n", indent.right(), this.toClassName((TNavigationProperty)x, imports));
                p.format("%scontextPath.addSegment(\"%s\"), %s.getValue(unmappedFields, \"%s\"));\n", indent.right().right().right().right(), x.getName(), imports.add(RequestHelper.class), x.getName());
                indent.left().left().left().left();
            } else {
                if (!this.names.isEntityWithNamespace(this.names.getType((TNavigationProperty)x))) throw new RuntimeException("unexpected");
                Schema sch = this.names.getSchema(this.names.getInnerType(this.names.getType((TNavigationProperty)x)));
                p.format("%sreturn new %s(contextPath.addSegment(\"%s\"), %s.getValue(unmappedFields, \"%s\"));\n", indent.right(), imports.add(this.names.getFullClassNameEntityRequestFromTypeWithNamespace(sch, this.names.getInnerType(this.names.getType((TNavigationProperty)x)))), x.getName(), imports.add(RequestHelper.class), x.getName());
            }
            p.format("%s}\n", indent.left());
        });
    }

    private String toClassName(TNavigationProperty x, Imports imports) {
        Preconditions.checkArgument((x.getType().size() == 1 ? 1 : 0) != 0);
        String t = x.getType().get(0);
        if (!this.isCollection(x)) {
            if (x.isNullable() != null && x.isNullable().booleanValue()) {
                String r = this.names.toImportedFullClassName(t, imports, List.class);
                return imports.add(Optional.class) + "<" + r + ">";
            }
            Schema sch = this.names.getSchema(this.names.getInnerType(t));
            return imports.add(this.names.getFullClassNameEntityRequestFromTypeWithNamespace(sch, t));
        }
        String inner = this.names.getInnerType(t);
        Schema schema = this.names.getSchema(inner);
        return imports.add(this.names.getFullClassNameCollectionRequestFromTypeWithNamespace(schema, inner));
    }

    private String toClassName(TSingleton x, Imports imports) {
        String t = x.getType();
        if (!Generator.isCollection(x.getType())) {
            Schema sch = this.names.getSchema(this.names.getInnerType(t));
            return imports.add(this.names.getFullClassNameEntityRequestFromTypeWithNamespace(sch, t));
        }
        return this.names.toImportedFullClassName(t, imports, CollectionPageEntityRequest.class);
    }

    private boolean isCollection(TProperty x) {
        return Generator.isCollection(this.names.getType(x));
    }

    private boolean isCollection(TNavigationProperty x) {
        return Generator.isCollection(this.names.getType(x));
    }

    private static boolean isCollection(String t) {
        return t.startsWith(COLLECTION_PREFIX) && t.endsWith(")");
    }

    private static final class KeyInfo {
        final String typedParams;
        final String addKeys;

        KeyInfo(String typedParams, String addKeys) {
            this.typedParams = typedParams;
            this.addKeys = addKeys;
        }
    }

    private static final class Pair<A, B> {
        final A a;
        final B b;

        Pair(A a, B b) {
            this.a = a;
            this.b = b;
        }
    }
}

