/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.odata.client.generator;

import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.oasisopen.odata.csdl.v4.Schema;
import org.oasisopen.odata.csdl.v4.TAction;
import org.oasisopen.odata.csdl.v4.TActionFunctionParameter;
import org.oasisopen.odata.csdl.v4.TActionFunctionReturnType;
import org.oasisopen.odata.csdl.v4.TAnnotations;
import org.oasisopen.odata.csdl.v4.TComplexType;
import org.oasisopen.odata.csdl.v4.TEntityContainer;
import org.oasisopen.odata.csdl.v4.TEntitySet;
import org.oasisopen.odata.csdl.v4.TEntityType;
import org.oasisopen.odata.csdl.v4.TFunction;
import org.oasisopen.odata.csdl.v4.TNavigationProperty;
import org.oasisopen.odata.csdl.v4.TProperty;

public final class Util {
    public static <T> Stream<T> types(Schema schema, Class<T> cls) {
        return Util.filter(schema.getComplexTypeOrEntityTypeOrTypeDefinition(), cls);
    }

    public static <T> Stream<T> filter(Collection<?> c, Class<T> cls) {
        return c.stream().filter(cls::isInstance);
    }

    static void replaceAliases(List<Schema> schemas) {
        for (Schema schema : schemas) {
            for (Schema aliasedSchema : schemas) {
                Util.replaceAliases(schema, aliasedSchema);
            }
        }
    }

    static void replaceAliases(Schema schema, Schema aliasedSchema) {
        Util.types(schema, TEntityType.class).forEach(x -> Util.replaceAlias(aliasedSchema, x));
        Util.types(schema, TComplexType.class).forEach(x -> Util.replaceAlias(aliasedSchema, x));
        Util.types(schema, TAction.class).forEach(x -> Util.replaceAlias(aliasedSchema, x));
        Util.types(schema, TFunction.class).forEach(x -> Util.replaceAlias(aliasedSchema, x));
        Util.types(schema, TEntityContainer.class).forEach(x -> Util.replaceAlias(aliasedSchema, x));
    }

    private static void replaceAlias(Schema schema, Object x) {
        if (schema.getAlias() == null) {
            return;
        }
        if (x instanceof TEntityType) {
            TEntityType p = (TEntityType)x;
            p.setBaseType(Util.replaceAlias(schema, p.getBaseType()));
            p.getKeyOrPropertyOrNavigationProperty().forEach(y -> Util.replaceAlias(schema, y));
        } else if (x instanceof TComplexType) {
            TComplexType p = (TComplexType)x;
            p.setBaseType(Util.replaceAlias(schema, p.getBaseType()));
            p.getPropertyOrNavigationPropertyOrAnnotation().forEach(y -> Util.replaceAlias(schema, y));
        } else if (x instanceof TAction) {
            TAction a = (TAction)x;
            a.getParameterOrAnnotationOrReturnType().forEach(y -> Util.replaceAlias(schema, y));
        } else if (x instanceof TFunction) {
            TFunction a = (TFunction)x;
            a.getParameterOrAnnotation().forEach(y -> Util.replaceAlias(schema, y));
            Util.replaceAlias(schema, a.getReturnType());
        } else if (x instanceof TActionFunctionParameter) {
            TActionFunctionParameter p = (TActionFunctionParameter)x;
            Util.replaceAlias(schema, p.getType());
        } else if (x instanceof TActionFunctionReturnType) {
            TActionFunctionReturnType p = (TActionFunctionReturnType)x;
            Util.replaceAlias(schema, p.getType());
        } else if (x instanceof TProperty) {
            TProperty p = (TProperty)x;
            Util.replaceAlias(schema, p.getType());
        } else if (x instanceof TNavigationProperty) {
            TNavigationProperty p = (TNavigationProperty)x;
            Util.replaceAlias(schema, p.getType());
        } else if (x instanceof TAnnotations) {
            TAnnotations a = (TAnnotations)x;
            a.setTarget(Util.replaceAlias(schema, a.getTarget()));
        } else if (x instanceof TEntityContainer) {
            TEntityContainer a = (TEntityContainer)x;
            Util.filter(a.getEntitySetOrActionImportOrFunctionImport(), TEntitySet.class).forEach(y -> Util.replaceAlias(schema, y));
        } else if (x instanceof TEntitySet) {
            TEntitySet a = (TEntitySet)x;
            a.setEntityType(Util.replaceAlias(schema, a.getEntityType()));
        }
    }

    private static void replaceAlias(Schema schema, List<String> types) {
        List list = types.stream().map(y -> Util.replaceAlias(schema, y)).collect(Collectors.toList());
        types.clear();
        types.addAll(list);
    }

    private static String replaceAlias(Schema schema, String type) {
        return Util.replaceAlias(schema.getAlias(), schema.getNamespace(), type);
    }

    @VisibleForTesting
    static String replaceAlias(String alias, String namespace, String type) {
        if (type == null || alias == null) {
            return type;
        }
        if (Pattern.matches("^Collection\\(" + alias + "\\.[^.]+\\)$", type)) {
            return type.replaceFirst("^Collection\\(" + alias + "\\b", "Collection(" + namespace);
        }
        if (Pattern.matches("^" + alias + "\\.[^.]+$", type)) {
            return type.replaceFirst("^" + alias + "\\b", namespace);
        }
        return type;
    }
}

