/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.odata.client.generator.model;

import com.github.davidmoten.odata.client.generator.Names;
import com.github.davidmoten.odata.client.generator.Util;
import com.github.davidmoten.odata.client.generator.model.KeyElement;
import com.github.davidmoten.odata.client.generator.model.Structure;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.oasisopen.odata.csdl.v4.Schema;
import org.oasisopen.odata.csdl.v4.TEntityKeyElement;
import org.oasisopen.odata.csdl.v4.TEntityType;
import org.oasisopen.odata.csdl.v4.TNavigationProperty;
import org.oasisopen.odata.csdl.v4.TProperty;

public final class EntityType
extends Structure<TEntityType> {
    private Schema schema;

    public EntityType(TEntityType c, Names names) {
        super(c, TEntityType.class, names);
    }

    @Override
    public String getName() {
        return ((TEntityType)this.value).getName();
    }

    @Override
    public String getBaseType() {
        return ((TEntityType)this.value).getBaseType();
    }

    @Override
    public List<TProperty> getProperties() {
        return Util.filter(((TEntityType)this.value).getKeyOrPropertyOrNavigationProperty(), TProperty.class).collect(Collectors.toList());
    }

    @Override
    public List<TNavigationProperty> getNavigationProperties() {
        return Util.filter(((TEntityType)this.value).getKeyOrPropertyOrNavigationProperty(), TNavigationProperty.class).collect(Collectors.toList());
    }

    @Override
    public Structure<TEntityType> create(TEntityType t) {
        return new EntityType(t, this.names);
    }

    @Override
    public boolean isEntityType() {
        return true;
    }

    @Override
    public String getSimpleClassName() {
        return this.names.getSimpleClassNameEntity(this.schema(), ((TEntityType)this.value).getName());
    }

    @Override
    public String getFullType() {
        return this.names.getFullTypeFromSimpleType(this.schema(), this.getName());
    }

    @Override
    public File getClassFile() {
        return this.names.getClassFileEntity(this.schema(), this.getName());
    }

    public File getClassFileEntityRequest() {
        return this.names.getClassFileEntityRequest(this.schema(), this.getName());
    }

    @Override
    public File getClassFileCollectionRequest() {
        return this.names.getClassFileEntityCollectionRequest(this.schema(), this.getName());
    }

    @Override
    public String getPackage() {
        return this.names.getPackageEntity(this.schema());
    }

    private Schema schema() {
        if (this.schema == null) {
            this.schema = this.names.getSchema((TEntityType)this.value);
        }
        return this.schema;
    }

    public String getFullClassNameEntity() {
        return this.names.getFullClassNameFromTypeWithoutNamespace(this.schema(), this.getName());
    }

    public String getSimpleClassNameEntityRequest() {
        return this.names.getSimpleClassNameEntityRequest(this.schema(), this.getName());
    }

    public String getPackageEntityRequest() {
        return this.names.getPackageEntityRequest(this.schema());
    }

    public File getDirectoryEntity() {
        return this.names.getDirectoryEntity(this.schema());
    }

    private List<KeyElement> getKeysLocal() {
        return Util.filter(((TEntityType)this.value).getKeyOrPropertyOrNavigationProperty(), TEntityKeyElement.class).map(x -> new KeyElement((TEntityKeyElement)x, this, this.names)).collect(Collectors.toList());
    }

    public List<KeyElement> getKeys() {
        return this.getHeirarchy().stream().flatMap(x -> ((EntityType)x).getKeysLocal().stream()).collect(Collectors.toList());
    }

    public boolean hasKey() {
        return this.getHeirarchy().stream().flatMap(x -> ((EntityType)x).getKeysLocal().stream()).findAny().isPresent();
    }

    public Optional<KeyElement> getFirstKey() {
        if (this.getKeys().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.getKeys().get(0));
    }

    @Override
    public boolean isAbstract() {
        return ((TEntityType)this.value).isAbstract();
    }

    public boolean hasStream() {
        return ((TEntityType)this.value).isHasStream();
    }

    public String getFullClassNameEntityRequest() {
        return this.getPackageEntityRequest() + "." + this.getSimpleClassNameEntityRequest();
    }
}

