/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.oas3.internal;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.oas3.internal.Names;
import com.github.davidmoten.oas3.internal.model.Association;
import com.github.davidmoten.oas3.internal.model.AssociationType;
import com.github.davidmoten.oas3.internal.model.Class;
import com.github.davidmoten.oas3.internal.model.ClassType;
import com.github.davidmoten.oas3.internal.model.Field;
import com.github.davidmoten.oas3.internal.model.Inheritance;
import com.github.davidmoten.oas3.internal.model.Model;
import com.github.davidmoten.oas3.internal.model.Relationship;
import com.github.davidmoten.oas3.internal.model.SimpleType;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BinarySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ByteArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.EmailSchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.PasswordSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

final class Common {
    private static final Set<String> SIMPLE_TYPES_WITHOUT_BRACKETS = Arrays.stream(SimpleType.values()).map(x -> x.toString().replace("[]", "")).collect(Collectors.toSet());

    private Common() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Model toModelClass(String name, Schema<?> schema, Names names, ClassType classType) {
        Optional<String> t;
        ArrayList<Field> fields = new ArrayList<Field>();
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        ArrayList<Class> classes = new ArrayList<Class>();
        if (schema.get$ref() != null) {
            String otherClassName = names.refToClassName(schema.get$ref());
            relationships.add(Association.from(name).to(otherClassName).one().build());
        } else if (schema instanceof ComposedSchema) {
            ComposedSchema s = (ComposedSchema)schema;
            if (s.getOneOf() != null) {
                Common.addInheritance(classes, relationships, name, s.getOneOf(), names);
            } else if (s.getAnyOf() != null) {
                Common.addInheritance(classes, relationships, name, s.getAnyOf(), names);
            } else {
                if (s.getAllOf() == null) throw new RuntimeException("unexpected");
                Common.addMixedTypeAll(classes, relationships, name, s.getAllOf(), null, names);
            }
        } else if (schema.getProperties() != null) {
            Set required = schema.getRequired() != null ? new HashSet(schema.getRequired()) : Collections.emptySet();
            schema.getProperties().entrySet().forEach(entry -> {
                String property = (String)entry.getKey();
                Schema sch = (Schema)entry.getValue();
                if (sch instanceof ComposedSchema) {
                    AssociationType associationType;
                    List list;
                    ComposedSchema s = (ComposedSchema)sch;
                    boolean req = required.contains(property);
                    boolean isAll = false;
                    if (s.getOneOf() != null) {
                        list = s.getOneOf();
                        associationType = req ? AssociationType.ONE : AssociationType.ZERO_ONE;
                    } else if (s.getAnyOf() != null) {
                        list = s.getAnyOf();
                        associationType = req ? AssociationType.ONE : AssociationType.ZERO_ONE;
                    } else if (s.getAllOf() != null) {
                        list = s.getAllOf();
                        isAll = true;
                        associationType = null;
                    } else {
                        list = Collections.emptyList();
                        associationType = null;
                    }
                    if (!list.isEmpty()) {
                        if (isAll) {
                            Common.addMixedTypeAll(classes, relationships, name, list, property, names);
                        } else {
                            Common.addInheritanceForProperty(classes, relationships, name, list, property, associationType, names);
                        }
                    }
                } else if (sch.get$ref() != null) {
                    String ref = sch.get$ref();
                    String otherClassName = names.refToClassName(ref);
                    Common.addToOne(relationships, name, otherClassName, property, required.contains(entry.getKey()));
                } else {
                    Optional<String> t = Common.getUmlTypeName(sch, names);
                    if (t.isPresent()) {
                        String type = t.get();
                        if (Common.isComplexArrayType(type)) {
                            Common.addArray(name, classes, relationships, property, (ArraySchema)sch, names);
                        } else if (type.equals("object")) {
                            String otherClassName = names.nextClassName(name + "." + property);
                            Model m = Common.toModelClass(otherClassName, sch, names, classType);
                            classes.addAll(m.classes());
                            relationships.addAll(m.relationships());
                            Common.addToOne(relationships, name, otherClassName, property, required.contains(property));
                        } else {
                            fields.add(new Field((String)entry.getKey(), type, type.endsWith("]"), required.contains(entry.getKey())));
                        }
                    }
                }
            });
        } else if (schema instanceof ArraySchema) {
            String otherClassName;
            ArraySchema a = (ArraySchema)schema;
            Schema items = a.getItems();
            String ref = items.get$ref();
            if (ref != null) {
                otherClassName = names.refToClassName(ref);
            } else {
                otherClassName = names.nextClassName(name);
                Model m = Common.toModelClass(otherClassName, items, names, classType);
                classes.addAll(m.classes());
                relationships.addAll(m.relationships());
            }
            Common.addToMany(relationships, name, otherClassName);
        } else if (!(schema instanceof ObjectSchema) && (t = Common.getUmlTypeName(schema, names)).isPresent()) {
            String type = t.get();
            fields.add(new Field("value", type, type.endsWith("]"), true));
        }
        classes.add(new Class(name, classType, fields));
        return new Model(classes, relationships);
    }

    private static boolean isComplexArrayType(String type) {
        return type.endsWith("[]") && !Common.isSimpleType(type);
    }

    static boolean isSimpleType(String s) {
        return SIMPLE_TYPES_WITHOUT_BRACKETS.contains(s.replace("[", "").replace("]", ""));
    }

    private static void addArray(String name, List<Class> classes, List<Relationship> relationships, String property, ArraySchema a, Names names) {
        String otherClassName;
        Preconditions.checkNotNull((Object)property);
        Schema items = a.getItems();
        String ref = items.get$ref();
        if (ref != null) {
            otherClassName = names.refToClassName(ref);
        } else {
            otherClassName = names.nextClassName(name + "." + property);
            Model m = Common.toModelClass(otherClassName, items, names, ClassType.SCHEMA);
            classes.addAll(m.classes());
            relationships.addAll(m.relationships());
        }
        Common.addToMany(relationships, name, otherClassName, property);
    }

    private static void addMixedTypeAll(List<Class> classes, List<Relationship> relationships, String name, List<Schema> schemas, String propertyName, Names names) {
        List<String> otherClassNames = Common.addAnonymousClassesAndReturnOtherClassNames(classes, relationships, name, schemas, names, propertyName);
        for (String otherClassName : otherClassNames) {
            Common.addToOne(relationships, name, otherClassName, propertyName, true);
        }
    }

    private static void addInheritanceForProperty(List<Class> classes, List<Relationship> relationships, String name, List<Schema> schemas, String propertyName, AssociationType associationType, Names names) {
        List<String> otherClassNames = Common.addAnonymousClassesAndReturnOtherClassNames(classes, relationships, name, schemas, names, propertyName);
        Inheritance inheritance = new Inheritance(name, otherClassNames, associationType, Optional.of(propertyName));
        relationships.add(inheritance);
    }

    private static void addInheritance(List<Class> classes, List<Relationship> relationships, String name, List<Schema> schemas, Names names) {
        List<String> otherClassNames = Common.addAnonymousClassesAndReturnOtherClassNames(classes, relationships, name, schemas, names, null);
        relationships.add(new Inheritance(name, otherClassNames, AssociationType.ONE, Optional.empty()));
    }

    private static List<String> addAnonymousClassesAndReturnOtherClassNames(List<Class> classes, List<Relationship> relationships, String name, List<Schema> schemas, Names names, String property) {
        List<String> otherClassNames = schemas.stream().map(s -> {
            if (s.get$ref() != null) {
                return names.refToClassName(s.get$ref());
            }
            String className = names.nextClassName(name + (property == null ? "" : "." + property));
            Model m = Common.toModelClass(className, s, names, ClassType.SCHEMA);
            classes.addAll(m.classes());
            relationships.addAll(m.relationships());
            return className;
        }).collect(Collectors.toList());
        return otherClassNames;
    }

    private static void addToMany(List<Relationship> relationships, String name, String otherClassName) {
        Common.addToMany(relationships, name, otherClassName, null);
    }

    private static void addToMany(List<Relationship> relationships, String name, String otherClassName, String property) {
        relationships.add(Association.from(name).to(otherClassName).many().propertyOrParameterName(Optional.ofNullable(property)).build());
    }

    private static void addToOne(List<Relationship> relationships, String name, String otherClassName, String property, boolean isToOne) {
        relationships.add(Association.from(name).to(otherClassName).type(isToOne ? AssociationType.ONE : AssociationType.ZERO_ONE).propertyOrParameterName(property == null || property.equals(otherClassName) ? Optional.empty() : Optional.of(property)).build());
    }

    private static Optional<String> getUmlTypeName(Schema<?> schema, Names names) {
        return Common.getUmlTypeName(schema.get$ref(), schema, names);
    }

    static Optional<String> getUmlTypeName(String ref, Schema<?> schema, Names names) {
        String type;
        if (ref != null) {
            type = names.refToClassName(ref);
        } else if (schema == null) {
            type = null;
        } else if (schema instanceof StringSchema) {
            type = "string";
        } else if (schema instanceof BooleanSchema) {
            type = "boolean";
        } else if (schema instanceof DateTimeSchema) {
            type = "timestamp";
        } else if (schema instanceof DateSchema) {
            type = "date";
        } else if (schema instanceof NumberSchema) {
            type = "decimal";
        } else if (schema instanceof IntegerSchema) {
            type = "integer";
        } else if (schema instanceof ArraySchema) {
            ArraySchema a = (ArraySchema)schema;
            type = Common.getUmlTypeName(a.getItems(), names).orElseThrow(() -> new RuntimeException("unexpected")) + "[]";
        } else if (schema instanceof BinarySchema) {
            type = "byte[]";
        } else if (schema instanceof ByteArraySchema) {
            type = "byte[]";
        } else if (schema instanceof ObjectSchema) {
            type = "object";
        } else if (schema instanceof FileSchema) {
            type = "string";
        } else if (schema instanceof PasswordSchema) {
            type = "string";
        } else if (schema instanceof EmailSchema) {
            type = "string";
        } else if (schema instanceof UUIDSchema) {
            type = "string";
        } else if (schema instanceof MapSchema) {
            type = "map";
        } else if (schema instanceof ComposedSchema) {
            type = "string";
        } else if ("string".equals(schema.getType())) {
            type = "string";
        } else if (schema.get$ref() != null) {
            type = names.refToClassName(schema.get$ref());
        } else if (schema.getType() == null) {
            type = null;
        } else {
            throw new RuntimeException("not expected" + schema);
        }
        return Optional.ofNullable(type);
    }
}

