/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.oas3.internal;

import com.github.davidmoten.oas3.internal.Common;
import com.github.davidmoten.oas3.internal.Names;
import com.github.davidmoten.oas3.internal.Util;
import com.github.davidmoten.oas3.internal.model.Association;
import com.github.davidmoten.oas3.internal.model.Class;
import com.github.davidmoten.oas3.internal.model.ClassType;
import com.github.davidmoten.oas3.internal.model.Model;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;

public final class ComponentsHelper {
    private ComponentsHelper() {
    }

    public static Model toModel(Names names) {
        Model part1 = names.schemas().entrySet().stream().map(entry -> Common.toModelClass(names.schemaClassName((String)entry.getKey()), (Schema)entry.getValue(), names, ClassType.SCHEMA)).reduce(Model.EMPTY, (a, b) -> a.add((Model)b));
        Model part2 = names.requestBodies().entrySet().stream().map(entry -> {
            RequestBody b = (RequestBody)entry.getValue();
            String className = names.requestBodyClassName(b);
            String ref = b.get$ref();
            if (ref != null) {
                String otherClassName = names.refToClassName(ref);
                Class c = new Class(className, ClassType.REQUEST_BODY);
                Association a = Association.from(className).to(otherClassName).one().build();
                return new Model(c, a);
            }
            return Common.toModelClass(names.requestBodyClassName((String)entry.getKey()), ((MediaType)Util.first(((RequestBody)entry.getValue()).getContent()).get().getValue()).getSchema(), names, ClassType.REQUEST_BODY);
        }).reduce(Model.EMPTY, (a, b) -> a.add((Model)b));
        Model part3 = names.parameters().entrySet().stream().map(entry -> {
            Parameter p = (Parameter)entry.getValue();
            String className = names.parameterClassName(p);
            String ref = p.get$ref();
            if (ref != null) {
                Class c = new Class(className, ClassType.PARAMETER);
                String otherClassName = names.refToClassName(ref);
                Association a = Association.from(className).to(otherClassName).one().build();
                return new Model(c, a);
            }
            return Common.toModelClass(className, p.getSchema(), names, ClassType.PARAMETER);
        }).reduce(Model.EMPTY, (a, b) -> a.add((Model)b));
        Model part4 = names.responses().entrySet().stream().map(entry -> Util.first(Util.nullMapToEmpty(((ApiResponse)entry.getValue()).getContent())).map(x -> Common.toModelClass(names.responseClassName((String)entry.getKey()), ((MediaType)x.getValue()).getSchema(), names, ClassType.RESPONSE)).orElse(new Model(new Class(names.responseClassName((String)entry.getKey()), ClassType.RESPONSE)))).reduce(Model.EMPTY, (a, b) -> a.add((Model)b));
        return part1.add(part2).add(part3).add(part4);
    }
}

