/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.oas3.internal;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.guavamini.Sets;
import com.github.davidmoten.oas3.internal.Util;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Names {
    private static final String EMPTY_RESPONSE_CLASS_NAME = "Empty Response";
    private final Map<String, String> refClassNames = new HashMap<String, String>();
    private final Set<String> classNames = Sets.newHashSet((Object[])new String[]{"Empty Response"});
    private final OpenAPI openapi;

    public Names(OpenAPI a) {
        Components components = a.getComponents();
        this.openapi = a;
        if (components != null) {
            Util.nullMapToEmpty(components.getSchemas()).keySet().forEach(name -> {
                String className = Names.nextClassName(this.classNames, name);
                this.refClassNames.put("#/components/schemas/" + name, className);
            });
            Util.nullMapToEmpty(components.getRequestBodies()).keySet().forEach(name -> {
                String className = Names.nextClassName(this.classNames, name);
                this.refClassNames.put("#/components/requestBodies/" + name, className);
            });
            Util.nullMapToEmpty(components.getParameters()).keySet().forEach(name -> {
                String className = Names.nextClassName(this.classNames, name);
                this.refClassNames.put("#/components/parameters/" + name, className);
            });
            Util.nullMapToEmpty(components.getResponses()).keySet().forEach(name -> {
                String className = Names.nextClassName(this.classNames, name);
                this.refClassNames.put("#/components/responses/" + name, className);
            });
        }
    }

    String schemaClassName(String simpleName) {
        return this.refToClassName("#/components/schemas/" + simpleName);
    }

    String requestBodyClassName(String simpleName) {
        return this.refToClassName("#/components/requestBodies/" + simpleName);
    }

    String responseClassName(String simpleName) {
        return this.refToClassName("#/components/responses/" + simpleName);
    }

    private String parameterClassName(String simpleName) {
        return this.refToClassName("#/components/parameters/" + simpleName);
    }

    String requestBodyClassName(RequestBody b) {
        return Util.nullMapToEmpty(this.components().getRequestBodies()).entrySet().stream().filter(entry -> entry.getValue() == b).map(entry -> this.requestBodyClassName((String)entry.getKey())).findFirst().orElseThrow(() -> new RuntimeException("cound not find " + b));
    }

    String parameterClassName(Parameter p) {
        return Util.nullMapToEmpty(this.components().getParameters()).entrySet().stream().filter(entry -> entry.getValue() == p).map(entry -> this.parameterClassName((String)entry.getKey())).findFirst().orElseThrow(() -> new RuntimeException("cound not find " + p));
    }

    String refToClassName(String ref) {
        Preconditions.checkNotNull((Object)ref);
        String className = this.refClassNames.get(ref);
        if (className == null) {
            throw new RuntimeException("could not find ref=" + ref);
        }
        return className;
    }

    Components components() {
        return this.openapi.getComponents();
    }

    Paths paths() {
        return this.openapi.getPaths();
    }

    String nextClassName(String candidate) {
        return Names.nextClassName(this.classNames, candidate);
    }

    private static String nextClassName(Set<String> classNames, String ... candidates) {
        return Names.nextClassName(classNames, Arrays.asList(candidates));
    }

    private static String nextClassName(Set<String> classNames, List<String> candidates) {
        Preconditions.checkArgument((!candidates.isEmpty() ? 1 : 0) != 0);
        for (String candidate : candidates) {
            if (classNames.contains(candidate)) continue;
            classNames.add(candidate);
            return candidate;
        }
        int i = 1;
        String lastCandidate = candidates.get(candidates.size() - 1);
        while (true) {
            String className;
            if (!classNames.contains(className = lastCandidate + "." + i)) {
                classNames.add(className);
                return className;
            }
            ++i;
        }
    }

    Map<String, Schema> schemas() {
        if (this.openapi.getComponents() == null) {
            return Collections.emptyMap();
        }
        return Util.nullMapToEmpty(this.openapi.getComponents().getSchemas());
    }

    Map<String, RequestBody> requestBodies() {
        if (this.openapi.getComponents() == null) {
            return Collections.emptyMap();
        }
        return Util.nullMapToEmpty(this.openapi.getComponents().getRequestBodies());
    }

    Map<String, Parameter> parameters() {
        if (this.openapi.getComponents() == null) {
            return Collections.emptyMap();
        }
        return Util.nullMapToEmpty(this.openapi.getComponents().getParameters());
    }

    Map<String, ApiResponse> responses() {
        if (this.openapi.getComponents() == null) {
            return Collections.emptyMap();
        }
        return Util.nullMapToEmpty(this.openapi.getComponents().getResponses());
    }
}

