/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.oas3.internal;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.oas3.internal.Common;
import com.github.davidmoten.oas3.internal.Names;
import com.github.davidmoten.oas3.internal.Util;
import com.github.davidmoten.oas3.internal.model.Association;
import com.github.davidmoten.oas3.internal.model.AssociationType;
import com.github.davidmoten.oas3.internal.model.Class;
import com.github.davidmoten.oas3.internal.model.ClassType;
import com.github.davidmoten.oas3.internal.model.Field;
import com.github.davidmoten.oas3.internal.model.Model;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class PathsHelper {
    private PathsHelper() {
    }

    public static Model toModel(Names names) {
        return PathsHelper.paths(names);
    }

    private static Model paths(Names names) {
        if (names.paths() == null) {
            return Model.EMPTY;
        }
        return names.paths().entrySet().stream().map(entry -> PathsHelper.toModelPath((String)entry.getKey(), (PathItem)entry.getValue(), names)).reduce(Model.EMPTY, (a, b) -> a.add((Model)b));
    }

    private static Model toModelPath(String path, PathItem p, Names names) {
        return p.readOperationsMap().entrySet().stream().map(entry -> {
            Operation operation = (Operation)entry.getValue();
            String className = entry.getKey() + " " + path;
            FieldsWithModel f = PathsHelper.toModelParameters(names, className, operation.getParameters());
            Model m = new Model(new Class(className, ClassType.METHOD, f.fields)).add(f.model);
            m = m.add(PathsHelper.toModelResponses(names, operation, className));
            return m.add(PathsHelper.toModelRequestBody(className, operation, names));
        }).reduce(Model.EMPTY, (a, b) -> a.add((Model)b));
    }

    private static FieldsWithModel toModelParameters(Names names, String className, List<Parameter> parameters) {
        return Util.nullListToEmpty(parameters).stream().map(param -> PathsHelper.toModelParameter(names, className, param)).reduce(FieldsWithModel.EMPTY, (a, b) -> a.add((FieldsWithModel)b));
    }

    private static FieldsWithModel toModelParameter(Names names, String className, Parameter param) {
        Model model;
        String ref = param.get$ref();
        String parameterName = param.getName();
        Boolean required = param.getRequired();
        if (ref != null) {
            Parameter p = param;
            while (p.get$ref() != null) {
                String r = p.get$ref();
                p = PathsHelper.getParameter(names.components(), r);
            }
            parameterName = p.getName();
            required = p.getRequired();
        }
        if (ref != null) {
            Model model2 = new Model(Association.from(className).to(names.refToClassName(ref)).one().propertyOrParameterName(parameterName).build());
            return new FieldsWithModel(Collections.emptyList(), model2);
        }
        Optional<Object> field = Optional.empty();
        Optional<String> type = Common.getUmlTypeName(param.get$ref(), param.getSchema(), names);
        if (type.isPresent() && Common.isSimpleType(type.get())) {
            field = Optional.of(new Field(parameterName, type.get(), type.get().endsWith("]"), required));
            model = Model.EMPTY;
        } else {
            String anonClassName = names.nextClassName(className + "." + parameterName);
            Model m = param.getSchema() != null ? Common.toModelClass(anonClassName, param.getSchema(), names, ClassType.PARAMETER) : new Model(new Class(anonClassName, ClassType.PARAMETER));
            model = m.add(Association.from(className).to(anonClassName).type(required != false ? AssociationType.ONE : AssociationType.ZERO_ONE).propertyOrParameterName(parameterName).build());
        }
        return new FieldsWithModel(field.map(x -> Collections.singletonList(x)).orElse(Collections.emptyList()), model);
    }

    private static Parameter getParameter(Components components, String ref) {
        Preconditions.checkNotNull((Object)ref);
        Reference r = new Reference(ref);
        if ("#/components/parameters".equals(r.namespace)) {
            return (Parameter)components.getParameters().get(r.simpleName);
        }
        throw new RuntimeException("unexpected");
    }

    private static Model toModelRequestBody(String className, Operation operation, Names names) {
        RequestBody body = operation.getRequestBody();
        if (body != null) {
            String ref = body.get$ref();
            if (ref != null) {
                return new Model(Association.from(className).to(names.refToClassName(ref)).one().build());
            }
            Content content = body.getContent();
            if (content != null) {
                Model model;
                String requestBodyClassName;
                Map.Entry mediaType = Util.first(content).get();
                Schema sch = ((MediaType)mediaType.getValue()).getSchema();
                if (sch.get$ref() != null) {
                    requestBodyClassName = names.refToClassName(sch.get$ref());
                    model = Model.EMPTY;
                } else {
                    requestBodyClassName = className + " Request";
                    model = Common.toModelClass(requestBodyClassName, sch, names, ClassType.REQUEST_BODY);
                }
                Association a = Association.from(className).to(requestBodyClassName).one().build();
                return model.add(a);
            }
        }
        return Model.EMPTY;
    }

    private static Model toModelResponses(Names names, Operation operation, String className) {
        return operation.getResponses().entrySet().stream().map(ent -> {
            Model model;
            String responseCode = (String)ent.getKey();
            ApiResponse r = (ApiResponse)ent.getValue();
            if (r.get$ref() != null) {
                String returnClassName = names.refToClassName(r.get$ref());
                model = new Model(Association.from(className).to(returnClassName).one().responseCode(responseCode).build());
            } else if (r.getContent() == null) {
                String newReturnClassName = className + " " + responseCode;
                Model m = new Model(new Class(newReturnClassName, ClassType.RESPONSE));
                String returnClassName = newReturnClassName;
                model = m.add(Association.from(className).to(returnClassName).one().responseCode(responseCode).build());
            } else {
                Model m = Model.EMPTY;
                for (Map.Entry contentEntry : r.getContent().entrySet()) {
                    String returnClassName;
                    String contentType = (String)contentEntry.getKey();
                    String newReturnClassName = className + " " + responseCode + ("application/json".equals(contentType) ? "" : " " + contentType);
                    MediaType mediaType = (MediaType)contentEntry.getValue();
                    Schema sch = mediaType.getSchema();
                    if (sch == null) {
                        System.out.println("TODO handle null schema in response");
                        continue;
                    }
                    if (sch.get$ref() != null) {
                        returnClassName = names.refToClassName(sch.get$ref());
                        m = m.add(Association.from(className).to(returnClassName).one().responseCode(responseCode).responseContentType(contentType).build());
                        continue;
                    }
                    returnClassName = newReturnClassName;
                    m = m.add(Common.toModelClass(returnClassName, sch, names, ClassType.RESPONSE));
                    m = m.add(Association.from(className).to(returnClassName).one().responseCode(responseCode).responseContentType(contentType).build());
                }
                model = m;
            }
            return model;
        }).reduce(Model.EMPTY, (a, b) -> a.add((Model)b));
    }

    private static final class Reference {
        private final String namespace;
        private final String simpleName;

        private Reference(String ref) {
            this.namespace = ref.substring(0, ref.lastIndexOf("/"));
            this.simpleName = ref.substring(ref.lastIndexOf("/") + 1);
        }
    }

    private static final class FieldsWithModel {
        private static final FieldsWithModel EMPTY = new FieldsWithModel(Collections.emptyList(), Model.EMPTY);
        private final List<Field> fields;
        private final Model model;

        FieldsWithModel(List<Field> fields, Model model) {
            this.fields = fields;
            this.model = model;
        }

        FieldsWithModel add(FieldsWithModel f) {
            ArrayList<Field> list = new ArrayList<Field>(this.fields);
            list.addAll(f.fields);
            return new FieldsWithModel(list, this.model.add(f.model));
        }
    }
}

