/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.oas3.internal.model;

import com.github.davidmoten.oas3.internal.model.AssociationType;
import com.github.davidmoten.oas3.internal.model.Relationship;
import java.util.Optional;

public final class Association
implements Relationship {
    private final String from;
    private final String to;
    private final AssociationType type;
    private final Optional<String> responseCode;
    private final Optional<String> responseContentType;
    private final Optional<String> propertyOrParameterName;

    private Association(String from, String to, AssociationType type, Optional<String> responseCode, Optional<String> responseContentType, Optional<String> propertyOrParameterName) {
        this.from = from;
        this.to = to;
        this.type = type;
        this.responseCode = responseCode;
        this.responseContentType = responseContentType;
        this.propertyOrParameterName = propertyOrParameterName;
    }

    public String from() {
        return this.from;
    }

    public String to() {
        return this.to;
    }

    public AssociationType type() {
        return this.type;
    }

    public Optional<String> responseCode() {
        return this.responseCode;
    }

    public Optional<String> responseContentType() {
        return this.responseContentType;
    }

    public Optional<String> propertyOrParameterName() {
        return this.propertyOrParameterName;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Association [from=");
        b.append(this.from);
        b.append(", to=");
        b.append(this.to);
        b.append(", type=");
        b.append((Object)this.type);
        b.append(", responseCode=");
        b.append(Association.str(this.responseCode));
        b.append(", responseContentType=");
        b.append(Association.str(this.responseContentType));
        b.append(", propertyOrParameterName=");
        b.append(Association.str(this.propertyOrParameterName));
        b.append("]");
        return b.toString();
    }

    private static String str(Optional<?> o) {
        return o.map(x -> x.toString()).orElse("");
    }

    public static Builder from(String from) {
        return new Builder(from);
    }

    public static final class Builder3 {
        private final Builder b;

        Builder3(Builder b) {
            this.b = b;
        }

        public Association build() {
            return new Association(this.b.from, this.b.to, this.b.type, this.b.responseCode, this.b.responseContentType, this.b.propertyOrParameterName);
        }

        public Builder3 propertyOrParameterName(String label) {
            return this.propertyOrParameterName(Optional.of(label));
        }

        public Builder3 responseCode(String responseCode) {
            this.b.responseCode = Optional.of(responseCode);
            return this;
        }

        public Builder3 responseContentType(String responseContentType) {
            this.b.responseContentType = Optional.of(responseContentType);
            return this;
        }

        public Builder3 propertyOrParameterName(Optional<String> propertyOrParameterName) {
            this.b.propertyOrParameterName = propertyOrParameterName;
            return this;
        }
    }

    public static final class Builder2 {
        private final Builder b;

        Builder2(Builder b) {
            this.b = b;
        }

        public Builder3 one() {
            return this.type(AssociationType.ONE);
        }

        public Builder3 many() {
            return this.type(AssociationType.MANY);
        }

        public Builder3 zeroOne() {
            return this.type(AssociationType.ZERO_ONE);
        }

        public Builder3 type(AssociationType type) {
            this.b.type = type;
            return new Builder3(this.b);
        }
    }

    public static final class Builder {
        private final String from;
        private String to;
        private AssociationType type;
        private Optional<String> propertyOrParameterName = Optional.empty();
        private Optional<String> responseCode = Optional.empty();
        private Optional<String> responseContentType = Optional.empty();

        Builder(String from) {
            this.from = from;
        }

        public Builder2 to(String to) {
            this.to = to;
            return new Builder2(this);
        }
    }
}

