/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.oas3.internal.model;

import com.github.davidmoten.oas3.internal.model.ClassType;
import com.github.davidmoten.oas3.internal.model.Field;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;

public final class Class {
    private final String name;
    private final ClassType type;
    private final List<Field> fields;

    public Class(String name, ClassType type, List<Field> fields) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)((Object)type));
        Preconditions.checkNotNull(fields);
        this.name = name;
        this.type = type;
        this.fields = fields;
    }

    public Class(String name, ClassType type) {
        this(name, type, Collections.emptyList());
    }

    public String name() {
        return this.name;
    }

    public ClassType type() {
        return this.type;
    }

    public List<Field> fields() {
        return this.fields;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Class [name=");
        b.append(this.name);
        b.append(", type=");
        b.append((Object)this.type);
        b.append(", fields=");
        b.append(this.fields);
        b.append("]");
        return b.toString();
    }
}

