/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.oas3.internal.model;

import com.github.davidmoten.guavamini.Lists;
import com.github.davidmoten.oas3.internal.model.Class;
import com.github.davidmoten.oas3.internal.model.Relationship;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class Model {
    public static final Model EMPTY = new Model(Collections.emptyList(), Collections.emptyList());
    private final List<Class> classes;
    private final List<Relationship> relationships;

    public Model(List<Class> classes, List<Relationship> relationships) {
        this.classes = classes;
        this.relationships = relationships;
    }

    public Model(Class cls, Relationship r) {
        this(Collections.singletonList(cls), Collections.singletonList(r));
    }

    public Model(Class cls) {
        this(Collections.singletonList(cls), Collections.emptyList());
    }

    public Model(Relationship r) {
        this(Collections.emptyList(), Collections.singletonList(r));
    }

    public Model add(Model model) {
        ArrayList c = Lists.newArrayList(this.classes);
        ArrayList r = Lists.newArrayList(this.relationships);
        c.addAll(model.classes);
        r.addAll(model.relationships);
        return new Model(c, r);
    }

    public Model add(Relationship r) {
        ArrayList<Relationship> list = new ArrayList<Relationship>(this.relationships);
        list.add(r);
        return new Model(this.classes, list);
    }

    public List<Class> classes() {
        return this.classes;
    }

    public List<Relationship> relationships() {
        return this.relationships;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Model [");
        b.append(this.classes.stream().map(x -> "\n  " + x).collect(Collectors.joining(",")));
        b.append(this.relationships.stream().map(x -> "\n  " + x).collect(Collectors.joining(",")));
        b.append("\n]");
        return b.toString();
    }
}

