/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.oas3.puml;

import com.github.davidmoten.oas3.internal.ComponentsHelper;
import com.github.davidmoten.oas3.internal.Names;
import com.github.davidmoten.oas3.internal.PathsHelper;
import com.github.davidmoten.oas3.internal.Util;
import com.github.davidmoten.oas3.internal.model.Association;
import com.github.davidmoten.oas3.internal.model.AssociationType;
import com.github.davidmoten.oas3.internal.model.Class;
import com.github.davidmoten.oas3.internal.model.ClassType;
import com.github.davidmoten.oas3.internal.model.Inheritance;
import com.github.davidmoten.oas3.internal.model.Model;
import com.github.davidmoten.oas3.internal.model.Relationship;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.io.IOUtils;

public final class Converter {
    private static final String COLON = " : ";
    private static final String SPACE = " ";

    private Converter() {
    }

    public static String openApiToPuml(InputStream in) throws IOException {
        return Converter.openApiToPuml(IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8));
    }

    public static String openApiToPuml(File file) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            String string = Converter.openApiToPuml(in);
            return string;
        }
    }

    public static String openApiToPuml(String openApi) {
        SwaggerParseResult result = new OpenAPIParser().readContents(openApi, null, null);
        if (result.getOpenAPI() == null) {
            throw new IllegalArgumentException("Not an OpenAPI definition");
        }
        return Converter.openApiToPuml(result.getOpenAPI());
    }

    private static String openApiToPuml(OpenAPI a) {
        Names names = new Names(a);
        Model model = ComponentsHelper.toModel(names).add(PathsHelper.toModel(names));
        return "@startuml\nhide <<" + Converter.toStereotype(ClassType.METHOD).get() + ">> circle\nhide <<" + Converter.toStereotype(ClassType.RESPONSE).get() + ">> circle\nhide <<" + Converter.toStereotype(ClassType.PARAMETER).get() + ">> circle\nhide empty methods\nhide empty fields\nset namespaceSeparator none" + Converter.toPlantUml(model) + "\n\n@enduml";
    }

    private static String toPlantUml(Model model) {
        int anonNumber = 0;
        StringBuilder b = new StringBuilder();
        for (Class cls : model.classes()) {
            b.append("\n\nclass " + Util.quote(cls.name()) + Converter.toStereotype(cls.type()).map(x -> " <<" + x + ">>").orElse("") + " {");
            cls.fields().stream().forEach(f -> b.append("\n  " + f.name() + COLON + f.type() + (f.isRequired() ? "" : " {O}")));
            b.append("\n}");
        }
        for (Relationship r : model.relationships()) {
            String mult;
            Relationship a;
            if (r instanceof Association) {
                String label;
                String arrow;
                a = (Association)r;
                mult = Converter.toMultiplicity(((Association)a).type());
                if (((Association)a).responseCode().isPresent()) {
                    arrow = "..>";
                    label = ((Association)a).responseCode().get() + ((Association)a).responseContentType().filter(x -> !"application/json".equalsIgnoreCase((String)x)).map(x -> SPACE + x).orElse("");
                } else {
                    arrow = "-->";
                    label = ((Association)a).propertyOrParameterName().orElse("");
                }
                b.append("\n\n" + Util.quote(((Association)a).from()) + SPACE + arrow + SPACE + Util.quote(mult) + SPACE + Util.quote(((Association)a).to()) + (label.equals("") ? "" : "  :  " + Util.quote(label)));
                continue;
            }
            a = (Inheritance)r;
            if (((Inheritance)a).propertyName().isPresent() || ((Inheritance)a).type() != AssociationType.ONE) {
                mult = Converter.toMultiplicity(((Inheritance)a).type());
                String diamond = "anon" + ++anonNumber;
                b.append("\n\ndiamond " + diamond);
                b.append("\n\n" + Util.quote(((Inheritance)a).from()) + SPACE + "-->" + Util.quote(mult) + SPACE + Util.quote(diamond) + ((Inheritance)a).propertyName().map(x -> COLON + Util.quote(x)).orElse(""));
                for (String otherClassName : ((Inheritance)a).to()) {
                    b.append("\n\n" + Util.quote(otherClassName) + SPACE + "--|>" + SPACE + Util.quote(diamond));
                }
                continue;
            }
            for (String otherClassName : ((Inheritance)a).to()) {
                b.append("\n\n" + Util.quote(otherClassName) + SPACE + "--|>" + SPACE + Util.quote(((Inheritance)a).from()));
            }
        }
        return b.toString();
    }

    private static String toMultiplicity(AssociationType type) {
        String mult = type == AssociationType.ONE ? "1" : (type == AssociationType.ZERO_ONE ? "0..1" : "*");
        return mult;
    }

    private static Optional<String> toStereotype(ClassType type) {
        String result = type == ClassType.METHOD ? "Path" : (type == ClassType.PARAMETER ? "Parameter" : (type == ClassType.REQUEST_BODY ? "RequestBody" : (type == ClassType.RESPONSE ? "Response" : null)));
        return Optional.ofNullable(result);
    }
}

