/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.oas3.puml;

import com.github.davidmoten.oas3.puml.Converter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;
import net.sourceforge.plantuml.core.DiagramDescription;

public final class ConverterMain {
    private ConverterMain() {
    }

    static DiagramDescription writeFileFormatFromPuml(String puml, String filename, FileFormat fileFormat) throws IOException {
        File file = new File(filename);
        SourceStringReader reader = new SourceStringReader(puml);
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            DiagramDescription diagramDescription = reader.outputImage((OutputStream)os, new FileFormatOption(fileFormat));
            return diagramDescription;
        }
    }

    public static void main(String[] args) throws IOException {
        String usage = "Usage: java -jar openapi-to-plantuml-all.jar <OPENAPI_FILE> <FILE_FORMAT> <OUTPUT_FILE>\n  File formats are:\n    PUML\n" + Arrays.stream(FileFormat.values()).map(x -> "    " + x + "\n").collect(Collectors.joining());
        if (args.length != 3) {
            System.out.println(usage);
            throw new IllegalArgumentException("must pass 3 arguments");
        }
        String puml = Converter.openApiToPuml(new File(args[0]));
        String format = args[1];
        File out = new File(args[2]);
        if (format.equals("PUML")) {
            Files.write(out.toPath(), puml.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        } else {
            FileFormat ff = FileFormat.valueOf((String)format);
            ConverterMain.writeFileFormatFromPuml(puml, out.getPath(), ff);
        }
    }
}

