/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.plantuml.plugins;

import com.github.davidmoten.plantuml.plugins.SourceFileReaderExt;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.file.SuggestedFile;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.security.SFile;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.FileUtils;

@Mojo(name="generate", threadSafe=true)
public final class GenerateMojo
extends AbstractMojo {
    @Parameter(name="sources")
    private FileSet sources;
    @Parameter(name="outputDirectory", defaultValue="${project.build.directory}/generated-diagrams/")
    private File outputDirectory;
    @Parameter(name="charset", defaultValue="UTF-8")
    private String charset;
    @Parameter(name="configs")
    private List<String> configs;
    @Parameter(name="configFiles")
    private List<File> configFiles;
    @Parameter(name="formats")
    private List<String> formats;
    @Parameter(name="metadata", defaultValue="true")
    private boolean metadata;
    @Parameter(name="writePreproc", defaultValue="false")
    private boolean writePreproc;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="false")
    private boolean preserveDirectoryStructure;
    @Parameter(defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping execution");
            return;
        }
        if (this.formats == null) {
            this.formats = Collections.singletonList("PNG");
        }
        if (this.configs == null) {
            this.configs = new ArrayList<String>();
        }
        if (this.sources == null) {
            this.sources = new FileSet();
            this.sources.setDirectory(new File(this.project.getBasedir(), "src" + File.separator + "main" + File.separator + "plantuml").getAbsolutePath());
        }
        if (this.configFiles == null) {
            this.configFiles = Collections.emptyList();
        }
        this.getLog().info((CharSequence)("sources=" + this.sources));
        try {
            File sourcesDirectory;
            GenerateMojo.addConfigFiles(this.configs, this.configFiles);
            this.getLog().info((CharSequence)("configs=" + this.configs));
            if (this.sources.getIncludes().isEmpty()) {
                this.sources.addInclude("**/*.puml");
                this.sources.addInclude("**/*.plantuml");
                this.sources.addInclude("**/*.txt");
            }
            if (!(sourcesDirectory = new File(this.sources.getDirectory())).exists()) {
                this.getLog().info((CharSequence)"sources directory does not exist");
                return;
            }
            List files = FileUtils.getFiles((File)sourcesDirectory, (String)GenerateMojo.commaSeparate(this.sources.getIncludes()), (String)GenerateMojo.commaSeparate(this.sources.getExcludes()));
            ExecutorService executor = Executors.newWorkStealingPool();
            ArrayList relativePaths = new ArrayList();
            String firstFormat = this.formats.isEmpty() ? null : this.formats.get(0);
            for (File file : files) {
                for (String format : this.formats) {
                    executor.submit(() -> {
                        File outDir;
                        FileFormat fileFormat = FileFormat.valueOf((String)format.toUpperCase());
                        this.getLog().info((CharSequence)("generating image from " + file));
                        FileFormatOption option = new FileFormatOption(fileFormat, this.metadata);
                        if (this.preserveDirectoryStructure) {
                            Path rel = Paths.get(this.sources.getDirectory(), new String[0]).relativize(file.getParentFile().toPath());
                            this.getLog().info((CharSequence)("relative output path=" + rel));
                            outDir = Paths.get(this.outputDirectory.getAbsolutePath(), rel.toString()).toFile();
                        } else {
                            outDir = this.outputDirectory;
                        }
                        SourceFileReaderExt reader = new SourceFileReaderExt(Defines.createEmpty(), file, outDir, this.configs, this.charset, option);
                        for (GeneratedImage image : reader.getGeneratedImages()) {
                            this.getLog().info((CharSequence)("image " + image + " written to " + image.getPngFile()));
                            if (!firstFormat.equals(format)) continue;
                            relativePaths.add(this.outputDirectory.toPath().relativize(image.getPngFile().toPath()));
                            if (!this.writePreproc) continue;
                            this.extractPreproc(reader);
                        }
                        return null;
                    });
                }
            }
            executor.shutdown();
            executor.awaitTermination(10L, TimeUnit.MINUTES);
            File index = new File(this.outputDirectory, "index.md");
            StringBuilder b = new StringBuilder();
            relativePaths.sort((x, y) -> x.toString().compareTo(y.toString()));
            relativePaths.forEach(path -> {
                String name = GenerateMojo.removeExtension(path.toString());
                b.append("### " + name + "\n");
                b.append("![" + name + "](" + path + ")\n\n");
            });
            index.getParentFile().mkdirs();
            Files.write(index.toPath(), b.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private static String removeExtension(String s) {
        int i = s.lastIndexOf(".");
        if (i == -1) {
            return s;
        }
        return s.substring(0, i);
    }

    private static void addConfigFiles(List<String> configs, List<File> configFiles) throws IOException {
        for (File f : configFiles) {
            Files.readAllLines(f.toPath()).stream().map(x -> x.trim()).filter(x -> !x.isEmpty()).peek(x -> configs.add((String)x)).count();
        }
    }

    private static String commaSeparate(List<String> list) {
        return list.stream().collect(Collectors.joining(","));
    }

    private void extractPreproc(SourceFileReaderExt sourceFileReader) throws IOException {
        for (BlockUml blockUml : sourceFileReader.getBlocks()) {
            SuggestedFile suggested = sourceFileReader.extractSuggestedFile(blockUml).withPreprocFormat();
            SFile file = suggested.getFile(0);
            this.getLog().info((CharSequence)("exporting preprocessing source to " + file.getPrintablePath()));
            PrintWriter pw = file.createPrintWriter(this.charset);
            Throwable throwable = null;
            try {
                pw.println("'DO NOT EDIT THIS FILE, PREPROCESSED OUTPUT");
                for (CharSequence cs : blockUml.getDefinition(true)) {
                    String s = cs.toString();
                    if (s.trim().length() <= 0) continue;
                    pw.println(s);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (pw == null) continue;
                if (throwable != null) {
                    try {
                        pw.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                pw.close();
            }
        }
    }
}

