/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.plantuml.plugins;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.SourceFileReader;
import net.sourceforge.plantuml.preproc.Defines;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.io.FileUtils;

@Mojo(name="generate")
public final class GenerateMojo
extends AbstractMojo {
    @Parameter(name="sources")
    private FileSet sources;
    @Parameter(name="outputDirectory", defaultValue="${project.build.directory}/generated-diagrams/")
    private File outputDirectory;
    @Parameter(name="charset", defaultValue="UTF-8")
    private String charset;
    @Parameter(name="configs")
    private List<String> configs;
    @Parameter(name="configFiles")
    private List<File> configFiles;
    @Parameter(name="formats")
    private List<String> formats;
    @Parameter(name="metadata", defaultValue="true")
    private boolean metadata;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="false")
    private boolean preserveDirectoryStructure;

    public void execute() throws MojoExecutionException {
        if (this.formats == null) {
            this.formats = Collections.singletonList("PNG");
        }
        if (this.configs == null) {
            this.configs = new ArrayList<String>();
        }
        if (this.sources == null) {
            this.sources = new FileSet();
            this.sources.setDirectory(new File(this.project.getBasedir(), "src" + File.separator + "main" + File.separator + "plantuml").getAbsolutePath());
        }
        if (this.configFiles == null) {
            this.configFiles = Collections.emptyList();
        }
        this.getLog().info((CharSequence)("sources=" + this.sources));
        try {
            GenerateMojo.addConfigFiles(this.configs, this.configFiles);
            this.getLog().info((CharSequence)("configs=" + this.configs));
            if (this.sources.getIncludes().isEmpty()) {
                this.sources.addInclude("**/*.puml");
                this.sources.addInclude("**/*.plantuml");
                this.sources.addInclude("**/*.txt");
            }
            List files = FileUtils.getFiles((File)new File(this.sources.getDirectory()), (String)GenerateMojo.commaSeparate(this.sources.getIncludes()), (String)GenerateMojo.commaSeparate(this.sources.getExcludes()));
            for (File file : files) {
                for (String format : this.formats) {
                    File outDir;
                    FileFormat fileFormat = FileFormat.valueOf((String)format.toUpperCase());
                    this.getLog().info((CharSequence)("generating image from " + file));
                    FileFormatOption option = new FileFormatOption(fileFormat, this.metadata);
                    if (this.preserveDirectoryStructure) {
                        Path rel = Paths.get(this.sources.getDirectory(), new String[0]).relativize(file.getParentFile().toPath());
                        this.getLog().info((CharSequence)("relative output path=" + rel));
                        outDir = Paths.get(this.outputDirectory.getAbsolutePath(), rel.toString()).toFile();
                    } else {
                        outDir = this.outputDirectory;
                    }
                    this.getLog().info((CharSequence)("output directory=" + outDir));
                    SourceFileReader reader = new SourceFileReader(Defines.createEmpty(), file, outDir, this.configs, this.charset, option);
                    for (GeneratedImage image : reader.getGeneratedImages()) {
                        this.getLog().info((CharSequence)("image " + image + " written to " + image.getPngFile()));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private static void addConfigFiles(List<String> configs, List<File> configFiles) throws IOException {
        for (File f : configFiles) {
            Files.readAllLines(f.toPath()).stream().map(x -> x.trim()).filter(x -> !x.isEmpty()).peek(x -> configs.add((String)x)).count();
        }
    }

    private static String commaSeparate(List<String> list) {
        return list.stream().collect(Collectors.joining(","));
    }
}

