/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree2;

import com.github.davidmoten.rtree2.Entry;
import com.github.davidmoten.rtree2.Leaf;
import com.github.davidmoten.rtree2.Node;
import com.github.davidmoten.rtree2.NodePosition;
import com.github.davidmoten.rtree2.NonLeaf;
import com.github.davidmoten.rtree2.geometry.Geometry;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

final class Search {
    private Search() {
    }

    static <T, S extends Geometry> Iterable<Entry<T, S>> search(Node<T, S> node, Predicate<? super Geometry> condition) {
        return new SearchIterable<T, S>(node, condition);
    }

    static final class SearchIterator<T, S extends Geometry>
    implements Iterator<Entry<T, S>> {
        private final Predicate<? super Geometry> condition;
        private final Deque<NodePosition<T, S>> stack;
        private Entry<T, S> next;

        SearchIterator(Node<T, S> node, Predicate<? super Geometry> condition) {
            this.condition = condition;
            this.stack = new ArrayDeque<NodePosition<T, S>>(8);
            this.stack.push(new NodePosition<T, S>(node, 0));
        }

        @Override
        public boolean hasNext() {
            this.load();
            return this.next != null;
        }

        @Override
        public Entry<T, S> next() {
            this.load();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Entry<T, S> v = this.next;
            this.next = null;
            return v;
        }

        private void load() {
            if (this.next == null) {
                this.next = this.search();
            }
        }

        private Entry<T, S> search() {
            while (!this.stack.isEmpty()) {
                NodePosition<T, S> np = this.stack.peek();
                if (!np.hasRemaining()) {
                    this.searchAfterLastInNode();
                    continue;
                }
                if (np.node() instanceof NonLeaf) {
                    this.searchNonLeaf(np);
                    continue;
                }
                Entry<T, S> v = this.searchLeaf(np);
                if (v == null) continue;
                return v;
            }
            return null;
        }

        private Entry<T, S> searchLeaf(NodePosition<T, S> np) {
            int i = np.position();
            Leaf leaf = (Leaf)np.node();
            do {
                Entry entry;
                if (!this.condition.test((Geometry)(entry = leaf.entry(i)).geometry())) continue;
                np.setPosition(i + 1);
                return entry;
            } while (++i < leaf.count());
            np.setPosition(i);
            return null;
        }

        private void searchNonLeaf(NodePosition<T, S> np) {
            Node child = ((NonLeaf)np.node()).child(np.position());
            if (this.condition.test(child.geometry())) {
                this.stack.push(new NodePosition(child, 0));
            } else {
                np.setPosition(np.position() + 1);
            }
        }

        private void searchAfterLastInNode() {
            this.stack.pop();
            if (!this.stack.isEmpty()) {
                NodePosition<T, S> previous = this.stack.peek();
                previous.setPosition(previous.position() + 1);
            }
        }
    }

    static final class SearchIterable<T, S extends Geometry>
    implements Iterable<Entry<T, S>> {
        private final Node<T, S> node;
        private final Predicate<? super Geometry> condition;

        SearchIterable(Node<T, S> node, Predicate<? super Geometry> condition) {
            this.node = node;
            this.condition = condition;
        }

        @Override
        public Iterator<Entry<T, S>> iterator() {
            return new SearchIterator<T, S>(this.node, this.condition);
        }
    }
}

