/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree2.geometry.internal;

import com.github.davidmoten.guavamini.Objects;
import com.github.davidmoten.rtree2.geometry.Circle;
import com.github.davidmoten.rtree2.geometry.Line;
import com.github.davidmoten.rtree2.geometry.Point;
import com.github.davidmoten.rtree2.geometry.Rectangle;
import com.github.davidmoten.rtree2.geometry.internal.GeometryUtil;
import com.github.davidmoten.rtree2.geometry.internal.RectangleDouble;
import com.github.davidmoten.rtree2.internal.util.ObjectsHelper;

public final class CircleDouble
implements Circle {
    private final double x;
    private final double y;
    private final double radius;
    private final Rectangle mbr;

    private CircleDouble(double x, double y, double radius) {
        this.x = x;
        this.y = y;
        this.radius = radius;
        this.mbr = RectangleDouble.create(x - radius, y - radius, x + radius, y + radius);
    }

    public static CircleDouble create(double x, double y, double radius) {
        return new CircleDouble(x, y, radius);
    }

    @Override
    public double x() {
        return this.x;
    }

    @Override
    public double y() {
        return this.y;
    }

    @Override
    public double radius() {
        return this.radius;
    }

    @Override
    public Rectangle mbr() {
        return this.mbr;
    }

    @Override
    public double distance(Rectangle r) {
        return Math.max(0.0, GeometryUtil.distance(this.x, this.y, r) - this.radius);
    }

    @Override
    public boolean intersects(Rectangle r) {
        return this.distance(r) == 0.0;
    }

    @Override
    public boolean intersects(Circle c) {
        double total = this.radius + c.radius();
        return GeometryUtil.distanceSquared(this.x, this.y, c.x(), c.y()) <= total * total;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.x, this.y, this.radius});
    }

    public boolean equals(Object obj) {
        CircleDouble other = ObjectsHelper.asClass(obj, CircleDouble.class);
        if (other != null) {
            return Objects.equal((Object)this.x, (Object)other.x) && Objects.equal((Object)this.y, (Object)other.y) && Objects.equal((Object)this.radius, (Object)other.radius);
        }
        return false;
    }

    @Override
    public boolean intersects(Point point) {
        return Math.sqrt(this.sqr(this.x - point.x()) + this.sqr(this.y - point.y())) <= this.radius;
    }

    private double sqr(double x) {
        return x * x;
    }

    @Override
    public boolean intersects(Line line) {
        return line.intersects(this);
    }

    @Override
    public boolean isDoublePrecision() {
        return true;
    }
}

