/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree2.geometry.internal;

import com.github.davidmoten.guavamini.Objects;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.rtree2.geometry.Geometry;
import com.github.davidmoten.rtree2.geometry.Rectangle;
import com.github.davidmoten.rtree2.geometry.internal.GeometryUtil;
import com.github.davidmoten.rtree2.internal.util.ObjectsHelper;

public final class RectangleDouble
implements Rectangle {
    private final double x1;
    private final double y1;
    private final double x2;
    private final double y2;

    private RectangleDouble(double x1, double y1, double x2, double y2) {
        Preconditions.checkArgument((x2 >= x1 ? 1 : 0) != 0);
        Preconditions.checkArgument((y2 >= y1 ? 1 : 0) != 0);
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public static RectangleDouble create(double x1, double y1, double x2, double y2) {
        return new RectangleDouble(x1, y1, x2, y2);
    }

    @Override
    public double x1() {
        return this.x1;
    }

    @Override
    public double y1() {
        return this.y1;
    }

    @Override
    public double x2() {
        return this.x2;
    }

    @Override
    public double y2() {
        return this.y2;
    }

    @Override
    public Rectangle add(Rectangle r) {
        return new RectangleDouble(RectangleDouble.min(this.x1, r.x1()), RectangleDouble.min(this.y1, r.y1()), RectangleDouble.max(this.x2, r.x2()), RectangleDouble.max(this.y2, r.y2()));
    }

    @Override
    public boolean contains(double x, double y) {
        return x >= this.x1 && x <= this.x2 && y >= this.y1 && y <= this.y2;
    }

    @Override
    public boolean intersects(Rectangle r) {
        return GeometryUtil.intersects(this.x1, this.y1, this.x2, this.y2, r.x1(), r.y1(), r.x2(), r.y2());
    }

    @Override
    public double distance(Rectangle r) {
        return GeometryUtil.distance(this.x1, this.y1, this.x2, this.y2, r.x1(), r.y1(), r.x2(), r.y2());
    }

    @Override
    public Rectangle mbr() {
        return this;
    }

    public String toString() {
        return "Rectangle [x1=" + this.x1 + ", y1=" + this.y1 + ", x2=" + this.x2 + ", y2=" + this.y2 + "]";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.x1, this.y1, this.x2, this.y2});
    }

    public boolean equals(Object obj) {
        RectangleDouble other = ObjectsHelper.asClass(obj, RectangleDouble.class);
        if (other != null) {
            return Objects.equal((Object)this.x1, (Object)other.x1) && Objects.equal((Object)this.x2, (Object)other.x2) && Objects.equal((Object)this.y1, (Object)other.y1) && Objects.equal((Object)this.y2, (Object)other.y2);
        }
        return false;
    }

    @Override
    public double intersectionArea(Rectangle r) {
        if (!this.intersects(r)) {
            return 0.0;
        }
        return RectangleDouble.create(RectangleDouble.max(this.x1, r.x1()), RectangleDouble.max(this.y1, r.y1()), RectangleDouble.min(this.x2, r.x2()), RectangleDouble.min(this.y2, r.y2())).area();
    }

    @Override
    public Geometry geometry() {
        return this;
    }

    private static double max(double a, double b) {
        if (a < b) {
            return b;
        }
        return a;
    }

    private static double min(double a, double b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    @Override
    public double perimeter() {
        return 2.0 * (this.x2 - this.x1) + 2.0 * (this.y2 - this.y1);
    }

    @Override
    public double area() {
        return (this.x2 - this.x1) * (this.y2 - this.y1);
    }

    @Override
    public boolean isDoublePrecision() {
        return true;
    }
}

