/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree2.geometry.internal;

final class Vector {
    final double x;
    final double y;

    static Vector create(double x, double y) {
        return new Vector(x, y);
    }

    Vector(double x, double y) {
        this.x = x;
        this.y = y;
    }

    double dot(Vector v) {
        return this.x * v.x + this.y * v.y;
    }

    Vector times(double value) {
        return Vector.create(value * this.x, value * this.y);
    }

    Vector minus(Vector v) {
        return Vector.create(this.x - v.x, this.y - v.y);
    }

    double modulus() {
        return Math.sqrt(this.modulusSquared());
    }

    double modulusSquared() {
        return this.x * this.x + this.y * this.y;
    }
}

