/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rtree2.internal;

public final class Line2D {
    private final double x1;
    private final double x2;
    private final double y1;
    private final double y2;

    public Line2D(double x1, double y1, double x2, double y2) {
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
    }

    public double getX1() {
        return this.x1;
    }

    public double getX2() {
        return this.x2;
    }

    public double getY1() {
        return this.y1;
    }

    public double getY2() {
        return this.y2;
    }

    public double ptSegDist(double px, double py) {
        return Line2D.ptSegDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), px, py);
    }

    public static double ptSegDist(double x1, double y1, double x2, double y2, double px, double py) {
        return Math.sqrt(Line2D.ptSegDistSq(x1, y1, x2, y2, px, py));
    }

    public static double ptSegDistSq(double x1, double y1, double x2, double y2, double px, double py) {
        double projlenSq;
        double lenSq;
        double dotprod = (px -= x1) * (x2 -= x1) + (py -= y1) * (y2 -= y1);
        if ((lenSq = px * px + py * py - (projlenSq = dotprod <= 0.0 ? 0.0 : ((dotprod = (px = x2 - px) * x2 + (py = y2 - py) * y2) <= 0.0 ? 0.0 : dotprod * dotprod / (x2 * x2 + y2 * y2)))) < 0.0) {
            lenSq = 0.0;
        }
        return lenSq;
    }

    public boolean intersectsLine(Line2D l) {
        return Line2D.linesIntersect(l.getX1(), l.getY1(), l.getX2(), l.getY2(), this.getX1(), this.getY1(), this.getX2(), this.getY2());
    }

    static boolean linesIntersect(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        return Line2D.relativeCCW(x1, y1, x2, y2, x3, y3) * Line2D.relativeCCW(x1, y1, x2, y2, x4, y4) <= 0 && Line2D.relativeCCW(x3, y3, x4, y4, x1, y1) * Line2D.relativeCCW(x3, y3, x4, y4, x2, y2) <= 0;
    }

    private static int relativeCCW(double x1, double y1, double x2, double y2, double px, double py) {
        double ccw = (px -= x1) * (y2 -= y1) - (py -= y1) * (x2 -= x1);
        if (ccw == 0.0 && (ccw = px * x2 + py * y2) > 0.0 && (ccw = (px -= x2) * x2 + (py -= y2) * y2) < 0.0) {
            ccw = 0.0;
        }
        return ccw < 0.0 ? -1 : (ccw > 0.0 ? 1 : 0);
    }
}

