/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx;

import com.github.davidmoten.rx.Statistics;
import java.util.Comparator;
import rx.Observable;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.functions.Func2;

public final class Functions {
    private Functions() {
    }

    public static <T> Func1<T, T> identity() {
        return new Func1<T, T>(){

            public T call(T t) {
                return t;
            }
        };
    }

    public static <T> Func1<T, Boolean> alwaysTrue() {
        return new Func1<T, Boolean>(){

            public Boolean call(T t) {
                return true;
            }
        };
    }

    public static <T> Func1<T, Boolean> alwaysFalse() {
        return new Func1<T, Boolean>(){

            public Boolean call(T t) {
                return false;
            }
        };
    }

    public static <T, R> Func1<T, R> constant(final R r) {
        return new Func1<T, R>(){

            public R call(T t) {
                return r;
            }
        };
    }

    public static <T> Func0<T> constant0(final T t) {
        return new Func0<T>(){

            public T call() {
                return t;
            }
        };
    }

    public static <T> Func1<T, Boolean> not(final Func1<T, Boolean> f) {
        return new Func1<T, Boolean>(){

            public Boolean call(T t) {
                return (Boolean)f.call(t) == false;
            }
        };
    }

    public static <T> Func1<T, Observable<T>> just() {
        return new Func1<T, Observable<T>>(){

            public Observable<T> call(T t) {
                return Observable.just(t);
            }
        };
    }

    public static <T extends Number> Func2<T, T, T> add() {
        return new Func2<T, T, T>(){

            public T call(T a, T b) {
                if (a instanceof Integer) {
                    return ((Number)a).intValue() + ((Number)b).intValue();
                }
                if (a instanceof Long) {
                    return ((Number)a).longValue() + ((Number)b).longValue();
                }
                if (a instanceof Double) {
                    return ((Number)a).doubleValue() + ((Number)b).doubleValue();
                }
                if (a instanceof Float) {
                    return Float.valueOf(((Number)a).floatValue() + ((Number)b).floatValue());
                }
                if (a instanceof Byte) {
                    return ((Number)a).byteValue() + ((Number)b).byteValue();
                }
                if (a instanceof Short) {
                    return ((Number)a).shortValue() + ((Number)b).shortValue();
                }
                throw new RuntimeException("not implemented");
            }
        };
    }

    public static <T extends Number> Func2<Statistics, T, Statistics> collectStats() {
        return new Func2<Statistics, T, Statistics>(){

            public Statistics call(Statistics s, T t) {
                return s.add((Number)t);
            }
        };
    }

    public static <T> Func2<T, T, Integer> toFunc2(final Comparator<T> comparator) {
        return new Func2<T, T, Integer>(){

            public Integer call(T t1, T t2) {
                return comparator.compare(t1, t2);
            }
        };
    }

    public static <T, R> Func2<T, R, Boolean> alwaysTrue2() {
        return new Func2<T, R, Boolean>(){

            public Boolean call(T t1, R t2) {
                return true;
            }
        };
    }

    public static <T, R> Func2<T, R, Boolean> alwaysFalse2() {
        return new Func2<T, R, Boolean>(){

            public Boolean call(T t1, R t2) {
                return false;
            }
        };
    }

    public static <T> Func1<T, Boolean> isNull() {
        return new Func1<T, Boolean>(){

            public Boolean call(T t) {
                return t == null;
            }
        };
    }

    public static <T> Func1<T, Boolean> isNotNull() {
        return new Func1<T, Boolean>(){

            public Boolean call(T t) {
                return t != null;
            }
        };
    }
}

